/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.luava.http;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.conn.HttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleConnectionEvictor {
    private static final Logger log = LoggerFactory.getLogger(IdleConnectionEvictor.class);
    private static final AtomicInteger order = new AtomicInteger(1);
    private HttpClientConnectionManager connectionManager;
    private final long sleepTimeMs;
    private final long maxIdleTimeMs;
    private Thread thread;

    public IdleConnectionEvictor(HttpClientConnectionManager connectionManager, Long maxIdleTimeMs, Long sleepTimeMs) {
        if (connectionManager == null) {
            throw new IllegalArgumentException("connectionManager can not be null");
        }
        if (maxIdleTimeMs == null || maxIdleTimeMs <= 0L) {
            maxIdleTimeMs = 1800000L;
        }
        if (sleepTimeMs == null || sleepTimeMs <= 0L) {
            sleepTimeMs = 30000L;
        }
        this.maxIdleTimeMs = maxIdleTimeMs;
        this.sleepTimeMs = sleepTimeMs;
        this.connectionManager = connectionManager;
        this.initThread();
    }

    private void initThread() {
        this.thread = new Thread(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Thread.sleep(IdleConnectionEvictor.this.sleepTimeMs);
                        if (log.isInfoEnabled()) {
                            log.debug("idle connection evictor");
                        }
                        IdleConnectionEvictor.this.connectionManager.closeExpiredConnections();
                        if (IdleConnectionEvictor.this.maxIdleTimeMs <= 0L) continue;
                        IdleConnectionEvictor.this.connectionManager.closeIdleConnections(IdleConnectionEvictor.this.maxIdleTimeMs, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.error("", (Throwable)e);
                    }
                }
            }
        };
        this.thread.setDaemon(true);
        this.thread.setName("http-idle-connection-evictor-" + order.getAndIncrement());
    }

    public void start() {
        this.thread.start();
    }
}

