/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.luava.springmvc.exception;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.linuxprobe.luava.servlet.HttpServletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;

public abstract class UniversalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(UniversalExceptionHandler.class);

    public abstract Object handleAjaxRequest(HttpServletRequest var1, HttpServletResponse var2, HandlerMethod var3, Throwable var4);

    public Object handleOtherRequest(HttpServletRequest request, HttpServletResponse response, HandlerMethod handler, Throwable exception) {
        return this.handleAjaxRequest(request, response, handler, exception);
    }

    @ResponseBody
    @ExceptionHandler(value={Throwable.class})
    public Object handleException(HttpServletRequest request, HttpServletResponse response, Throwable exception, HandlerMethod handlerMethod) {
        if (log.isErrorEnabled()) {
            log.error("Controller:{}, Method:{}, URI:{}, Content-Type:{} ,\u5f02\u5e38\u4fe1\u606f:{}", new Object[]{handlerMethod.getBeanType().getName(), handlerMethod.getMethod().getName(), request.getRequestURI(), request.getHeader("Content-Type"), UniversalExceptionHandler.getStackTrace(exception)});
        }
        boolean isResponseBody = false;
        Class<ModelAndView> returnType = handlerMethod.getMethod().getReturnType();
        Class handlerType = handlerMethod.getBeanType();
        if (handlerType.isAnnotationPresent(RestController.class)) {
            if (!returnType.isAssignableFrom(ModelAndView.class) && handlerMethod.getMethod().isAnnotationPresent(ResponseBody.class)) {
                isResponseBody = true;
            }
        } else if (handlerType.isAnnotationPresent(Controller.class) && handlerType.isAnnotationPresent(ResponseBody.class)) {
            isResponseBody = true;
        }
        if (isResponseBody || HttpServletUtils.isAjax((HttpServletRequest)request)) {
            return this.handleAjaxRequest(request, response, handlerMethod, exception);
        }
        return this.handleOtherRequest(request, response, handlerMethod, exception);
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }
}

