/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.core.content;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.linuxprobe.crud.core.annoatation.Column;
import org.linuxprobe.crud.core.annoatation.JoinColumn;
import org.linuxprobe.crud.core.annoatation.Query;
import org.linuxprobe.crud.core.content.EntityInfo;
import org.linuxprobe.crud.core.content.UniversalCrudContent;
import org.linuxprobe.crud.core.query.BaseQuery;
import org.linuxprobe.crud.core.query.param.BaseParam;
import org.linuxprobe.luava.reflection.ReflectionUtils;
import org.linuxprobe.luava.string.StringUtils;

public class QueryInfo {
    private Class<?> queryEntityCalss;
    private Map<String, QueryFieldInfo> columnMapQueryFieldInfos;
    private List<QueryFieldInfo> queryFieldInfos;
    private List<QueryFieldInfo> queryParamFieldInfos;
    private List<QueryFieldInfo> baseQueryFieldInfos;

    public QueryInfo(Class<?> queryType) {
        if (queryType == null) {
            throw new IllegalArgumentException("type can't be null");
        }
        if (!BaseQuery.class.isAssignableFrom(queryType)) {
            throw new IllegalArgumentException(queryType.getName() + " is not a subclass of org.linuxprobe.crud.core.query.BaseQuery");
        }
        if (!queryType.isAnnotationPresent(Query.class)) {
            throw new IllegalArgumentException(queryType.getName() + " does not have callout org.linuxprobe.crud.core.annoatation.Query annotation");
        }
        this.columnMapQueryFieldInfos = new HashMap<String, QueryFieldInfo>();
        this.queryEntityCalss = queryType.getAnnotation(Query.class).value();
        this.queryFieldInfos = new LinkedList<QueryFieldInfo>();
        this.queryParamFieldInfos = new LinkedList<QueryFieldInfo>();
        this.baseQueryFieldInfos = new LinkedList<QueryFieldInfo>();
        List fields = ReflectionUtils.getAllFields(queryType);
        for (Field field : fields) {
            if (!BaseParam.class.isAssignableFrom(field.getType()) && !BaseQuery.class.isAssignableFrom(field.getType())) continue;
            QueryFieldInfo fieldInfo = new QueryFieldInfo();
            fieldInfo.setField(field);
            if (BaseParam.class.isAssignableFrom(field.getType())) {
                Column column;
                fieldInfo.setColumnName(StringUtils.humpToLine((String)field.getName()));
                if (field.isAnnotationPresent(Column.class) && !(column = field.getAnnotation(Column.class)).value().isEmpty()) {
                    fieldInfo.setColumnName(column.value());
                }
                this.queryParamFieldInfos.add(fieldInfo);
            } else if (BaseQuery.class.isAssignableFrom(field.getType())) {
                fieldInfo.setPrincipalColumn(StringUtils.humpToLine((String)(field.getName() + "Id")));
                EntityInfo querEntityInfo = UniversalCrudContent.getEntityInfo(this.queryEntityCalss);
                fieldInfo.setSubordinateColumn(querEntityInfo.getPrimaryKey().getColumnName());
                if (field.isAnnotationPresent(JoinColumn.class)) {
                    JoinColumn joinColumn = field.getAnnotation(JoinColumn.class);
                    if (!"".equals(joinColumn.value())) {
                        fieldInfo.setPrincipalColumn(joinColumn.value().trim());
                    } else if (!"".equals(joinColumn.principal())) {
                        fieldInfo.setPrincipalColumn(joinColumn.principal().trim());
                    }
                    if (!"".equals(joinColumn.subordinate())) {
                        fieldInfo.setSubordinateColumn(joinColumn.subordinate().trim());
                    }
                }
                this.baseQueryFieldInfos.add(fieldInfo);
            }
            this.columnMapQueryFieldInfos.put(fieldInfo.getColumnName(), fieldInfo);
            this.queryFieldInfos.add(fieldInfo);
        }
    }

    public Class<?> getQueryEntityCalss() {
        return this.queryEntityCalss;
    }

    public Map<String, QueryFieldInfo> getColumnMapQueryFieldInfos() {
        return this.columnMapQueryFieldInfos;
    }

    public List<QueryFieldInfo> getQueryFieldInfos() {
        return this.queryFieldInfos;
    }

    public List<QueryFieldInfo> getQueryParamFieldInfos() {
        return this.queryParamFieldInfos;
    }

    public List<QueryFieldInfo> getBaseQueryFieldInfos() {
        return this.baseQueryFieldInfos;
    }

    public static class QueryFieldInfo {
        private Field field;
        private String columnName;
        private String principalColumn;
        private String subordinateColumn;

        public boolean isQueryClass() {
            return BaseQuery.class.isAssignableFrom(this.field.getType());
        }

        public Field getField() {
            return this.field;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getPrincipalColumn() {
            return this.principalColumn;
        }

        public String getSubordinateColumn() {
            return this.subordinateColumn;
        }

        public void setField(Field field) {
            this.field = field;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public void setPrincipalColumn(String principalColumn) {
            this.principalColumn = principalColumn;
        }

        public void setSubordinateColumn(String subordinateColumn) {
            this.subordinateColumn = subordinateColumn;
        }
    }
}

