/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.core.jdbc;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.linuxprobe.crud.core.annoatation.Column;
import org.linuxprobe.crud.utils.SqlFieldUtil;
import org.linuxprobe.luava.string.StringUtils;

public class ResultSetConvert {
    public static <T> T convert(ResultSet resultSet, Class<T> type) throws SQLException {
        T instance = null;
        try {
            instance = type.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        List<Field> fields = SqlFieldUtil.getAllSqlSupportFields(type);
        List<String> columns = ResultSetConvert.getColumns(resultSet);
        for (Field field : fields) {
            Object value;
            block24: {
                String columnName = null;
                if (field.isAnnotationPresent(Column.class)) {
                    columnName = field.getAnnotation(Column.class).value();
                } else {
                    columnName = field.getName();
                    if (!columns.contains(columnName)) {
                        columnName = StringUtils.humpToLine((String)columnName);
                    }
                }
                value = null;
                try {
                    if (SqlFieldUtil.isFacultyOfBlob(field.getType())) {
                        value = resultSet.getBlob(columnName);
                        break block24;
                    }
                    if (SqlFieldUtil.isFacultyOfBoolean(field.getType())) {
                        value = resultSet.getBoolean(columnName);
                        break block24;
                    }
                    if (SqlFieldUtil.isFacultyOfChar(field.getType())) {
                        try {
                            value = resultSet.getString(columnName);
                        }
                        catch (Exception e) {
                            value = resultSet.getInt(columnName);
                        }
                        break block24;
                    }
                    if (SqlFieldUtil.isFacultyOfDate(field.getType())) {
                        value = resultSet.getDate(columnName);
                        break block24;
                    }
                    if (SqlFieldUtil.isFacultyOfEnum(field.getType())) {
                        try {
                            value = resultSet.getString(columnName);
                        }
                        catch (Exception e) {
                            value = resultSet.getInt(columnName);
                        }
                        break block24;
                    }
                    if (SqlFieldUtil.isFacultyOfNumber(field.getType())) {
                        if (BigDecimal.class.isAssignableFrom(field.getType())) {
                            value = resultSet.getBigDecimal(columnName);
                            break block24;
                        }
                        if (Byte.TYPE.isAssignableFrom(field.getType()) || Byte.class.isAssignableFrom(field.getType())) {
                            value = resultSet.getByte(columnName);
                            break block24;
                        }
                        if (Short.TYPE.isAssignableFrom(field.getType()) || Short.class.isAssignableFrom(field.getType())) {
                            value = resultSet.getShort(columnName);
                            break block24;
                        }
                        if (Integer.TYPE.isAssignableFrom(field.getType()) || Integer.class.isAssignableFrom(field.getType())) {
                            value = resultSet.getInt(columnName);
                            break block24;
                        }
                        if (Long.TYPE.isAssignableFrom(field.getType()) || Long.class.isAssignableFrom(field.getType())) {
                            value = resultSet.getLong(columnName);
                            break block24;
                        }
                        if (Float.TYPE.isAssignableFrom(field.getType()) || Float.class.isAssignableFrom(field.getType())) {
                            value = Float.valueOf(resultSet.getFloat(columnName));
                            break block24;
                        }
                        if (!Double.TYPE.isAssignableFrom(field.getType()) && !Double.class.isAssignableFrom(field.getType())) break block24;
                        value = resultSet.getDouble(columnName);
                        break block24;
                    }
                    if (!SqlFieldUtil.isFacultyOfString(field.getType())) break block24;
                    value = resultSet.getString(columnName);
                }
                catch (SQLException e) {
                    continue;
                }
            }
            SqlFieldUtil.setFieldValue(instance, field, value);
        }
        return instance;
    }

    public static List<String> getColumns(ResultSet resultSet) {
        int count = 0;
        try {
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(e);
        }
        LinkedList<String> columns = new LinkedList<String>();
        for (count = resultSet.getMetaData().getColumnCount(); count > 0; --count) {
            try {
                columns.add(resultSet.getMetaData().getColumnName(count));
                continue;
            }
            catch (SQLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return columns;
    }
}

