/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.core.sql.generator.impl.mysql;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.linuxprobe.crud.core.annoatation.BooleanHandler;
import org.linuxprobe.crud.core.annoatation.CharHandler;
import org.linuxprobe.crud.core.annoatation.DateHandler;
import org.linuxprobe.crud.core.annoatation.EnumHandler;
import org.linuxprobe.crud.core.annoatation.PrimaryKey;
import org.linuxprobe.crud.core.sql.generator.impl.mysql.MysqlEscape;
import org.linuxprobe.crud.core.validation.FieldValidation;
import org.linuxprobe.crud.exception.OperationNotSupportedException;
import org.linuxprobe.crud.utils.SqlFieldUtil;
import org.linuxprobe.luava.reflection.ReflectionUtils;
import org.springframework.util.StreamUtils;

public class MysqlFieldValueConversion {
    private static MysqlEscape mysqlEscape = new MysqlEscape();

    private static String getStringValue(Object record, Field field) {
        String fieldValue = (String)ReflectionUtils.getFieldValue((Object)record, (Field)field);
        if (fieldValue != null) {
            fieldValue = mysqlEscape.escape(fieldValue);
            fieldValue = mysqlEscape.getQuotation() + fieldValue + mysqlEscape.getQuotation();
        }
        return fieldValue;
    }

    private static String getDateValue(Object record, Field field) {
        Date fieldValue = (Date)ReflectionUtils.getFieldValue((Object)record, (Field)field);
        String result = null;
        if (fieldValue != null) {
            if (field.isAnnotationPresent(DateHandler.class)) {
                DateHandler dateHandler = field.getAnnotation(DateHandler.class);
                if (dateHandler.customerType().equals((Object)DateHandler.DateCustomerType.String)) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(dateHandler.pattern());
                    result = mysqlEscape.getQuotation() + dateFormat.format(fieldValue) + mysqlEscape.getQuotation();
                } else {
                    result = fieldValue.getTime() + "";
                }
            } else {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                result = mysqlEscape.getQuotation() + dateFormat.format(fieldValue) + mysqlEscape.getQuotation();
            }
        }
        return result;
    }

    private static String getEnumValue(Object record, Field field) {
        Enum fieldValue = (Enum)ReflectionUtils.getFieldValue((Object)record, (Field)field);
        String result = null;
        if (fieldValue != null) {
            EnumHandler enumHandler;
            result = fieldValue.ordinal() + "";
            if (field.isAnnotationPresent(EnumHandler.class) && (enumHandler = field.getAnnotation(EnumHandler.class)).value().equals((Object)EnumHandler.EnumCustomerType.Name)) {
                result = mysqlEscape.getQuotation() + fieldValue.name() + mysqlEscape.getQuotation();
            }
        }
        return result;
    }

    private static String getNumberValue(Object record, Field field) {
        Number fieldValue = (Number)ReflectionUtils.getFieldValue((Object)record, (Field)field);
        String result = null;
        if (fieldValue != null) {
            result = fieldValue + "";
        }
        return result;
    }

    private static String getBooleanValue(Object record, Field field) {
        Boolean fieldValue = (Boolean)ReflectionUtils.getFieldValue((Object)record, (Field)field);
        String result = null;
        if (fieldValue != null) {
            result = fieldValue != false ? "1" : "0";
            if (field.isAnnotationPresent(BooleanHandler.class)) {
                BooleanHandler booleanHandler = field.getAnnotation(BooleanHandler.class);
                if (booleanHandler.value().equals((Object)BooleanHandler.BooleanCustomerType.YesAndNo)) {
                    result = fieldValue.booleanValue() ? "'yes'" : "'no'";
                } else if (booleanHandler.value().equals((Object)BooleanHandler.BooleanCustomerType.TrueAndFalse)) {
                    result = fieldValue != false ? "'true'" : "'false'";
                }
            }
        }
        return result;
    }

    private static String getCharValue(Object record, Field field) {
        Character fieldValue = (Character)ReflectionUtils.getFieldValue((Object)record, (Field)field);
        String result = null;
        if (fieldValue != null) {
            CharHandler charHandler;
            result = fieldValue.charValue() + "";
            if (field.isAnnotationPresent(CharHandler.class) && (charHandler = field.getAnnotation(CharHandler.class)).value().equals((Object)CharHandler.CharCustomerType.ToString)) {
                result = mysqlEscape.getQuotation() + fieldValue + mysqlEscape.getQuotation();
            }
        }
        return result;
    }

    private static String getBlobValue(Object record, Field field) {
        Object fieldValue = ReflectionUtils.getFieldValue((Object)record, (Field)field);
        String result = null;
        if (fieldValue != null) {
            byte[] bin = null;
            if (Blob.class.isAssignableFrom(field.getType())) {
                Blob blob = (Blob)fieldValue;
                try {
                    bin = StreamUtils.copyToByteArray((InputStream)blob.getBinaryStream());
                }
                catch (IOException | SQLException e) {
                    throw new IllegalArgumentException(e);
                }
            } else if (byte[].class.isAssignableFrom(field.getType())) {
                bin = (byte[])fieldValue;
            } else if (Byte[].class.isAssignableFrom(field.getType())) {
                Byte[] binB = (Byte[])fieldValue;
                bin = new byte[binB.length];
                for (int i = 0; i < binB.length; ++i) {
                    bin[i] = binB[i];
                }
            }
            result = new String(bin, StandardCharsets.UTF_8);
            result = mysqlEscape.escape(result);
            result = mysqlEscape.getQuotation() + result + mysqlEscape.getQuotation();
            result = "CONVERT( " + result + ", BINARY )";
        }
        return result;
    }

    public static String conversion(Object entity, Field field, boolean enalbeCheckRule) {
        if (enalbeCheckRule) {
            FieldValidation.universalValidation(entity, field);
        }
        String result = null;
        if (SqlFieldUtil.isFacultyOfString(field.getType())) {
            result = MysqlFieldValueConversion.getStringValue(entity, field);
        } else if (SqlFieldUtil.isFacultyOfNumber(field.getType())) {
            result = MysqlFieldValueConversion.getNumberValue(entity, field);
        } else if (SqlFieldUtil.isFacultyOfBoolean(field.getType())) {
            result = MysqlFieldValueConversion.getBooleanValue(entity, field);
        } else if (SqlFieldUtil.isFacultyOfDate(field.getType())) {
            result = MysqlFieldValueConversion.getDateValue(entity, field);
        } else if (SqlFieldUtil.isFacultyOfEnum(field.getType())) {
            result = MysqlFieldValueConversion.getEnumValue(entity, field);
        } else if (SqlFieldUtil.isFacultyOfChar(field.getType())) {
            result = MysqlFieldValueConversion.getCharValue(entity, field);
        } else if (SqlFieldUtil.isFacultyOfBlob(field.getType())) {
            result = MysqlFieldValueConversion.getBlobValue(entity, field);
        }
        return result;
    }

    public static String deleteModelConversion(Object entity, Field field) {
        return MysqlFieldValueConversion.conversion(entity, field, false);
    }

    public static String updateModelConversion(Object entity, Field field) {
        String result = null;
        result = MysqlFieldValueConversion.conversion(entity, field, true);
        return result;
    }

    public static String insertModelConversion(Object entity, Field field) {
        String result = MysqlFieldValueConversion.updateModelConversion(entity, field);
        if (field.isAnnotationPresent(PrimaryKey.class) && result == null) {
            PrimaryKey primaryKey = field.getAnnotation(PrimaryKey.class);
            if (primaryKey.value().equals((Object)PrimaryKey.Strategy.UUID)) {
                try {
                    String uuid = (String)ReflectionUtils.getFieldValue((Object)entity, (Field)field);
                    if (uuid == null) {
                        uuid = UUID.randomUUID().toString().replaceAll("-", "");
                    }
                    ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)uuid, (boolean)true);
                    result = mysqlEscape.getQuotation() + uuid + mysqlEscape.getQuotation();
                }
                catch (Exception e) {
                    throw new OperationNotSupportedException("\u672a\u627e\u5230\u4e3b\u952e\u7684set\u65b9\u6cd5", e);
                }
            } else if (primaryKey.value().equals((Object)PrimaryKey.Strategy.ASSIGNED)) {
                throw new NullPointerException("primaryKey can't not be null");
            }
        }
        return result;
    }
}

