/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.core.sql.generator.impl.mysql;

import java.util.List;
import org.linuxprobe.crud.core.annoatation.UpdateIgnore;
import org.linuxprobe.crud.core.content.EntityInfo;
import org.linuxprobe.crud.core.content.UniversalCrudContent;
import org.linuxprobe.crud.core.sql.generator.Escape;
import org.linuxprobe.crud.core.sql.generator.UpdateSqlGenerator;
import org.linuxprobe.crud.core.sql.generator.impl.mysql.MysqlEscape;
import org.linuxprobe.crud.core.sql.generator.impl.mysql.MysqlFieldValueConversion;
import org.linuxprobe.crud.exception.OperationNotSupportedException;

public class MysqlUpdateSqlGenerator
extends MysqlEscape
implements UpdateSqlGenerator,
Escape {
    private String checkPrimaryKeyAndGetValue(Object entity, EntityInfo entityInfo) {
        if (entityInfo.getPrimaryKey() == null) {
            throw new OperationNotSupportedException(entity.getClass() + " cannot be without primary key, please use org.linuxprobe.crud.core.annoatation.PrimaryKey Mark the primary key");
        }
        String primaryKeyValue = MysqlFieldValueConversion.updateModelConversion(entity, entityInfo.getPrimaryKey().getField());
        if (primaryKeyValue == null) {
            throw new IllegalArgumentException("The primary key cannot be null");
        }
        if (String.class.isAssignableFrom(entityInfo.getPrimaryKey().getField().getType()) && primaryKeyValue.isEmpty()) {
            throw new IllegalArgumentException("The primary key cannot be empty");
        }
        return primaryKeyValue;
    }

    @Override
    public String toGlobalUpdateSql(Object entity) {
        EntityInfo entityInfo = UniversalCrudContent.getEntityInfo(entity.getClass());
        String table = entityInfo.getTableName();
        String primaryKeyValue = this.checkPrimaryKeyAndGetValue(entity, entityInfo);
        StringBuilder sqlBuilder = new StringBuilder("UPDATE `" + table + "` SET ");
        List<EntityInfo.FieldInfo> fieldInfos = entityInfo.getFieldInfos();
        for (EntityInfo.FieldInfo fieldInfo : fieldInfos) {
            if (fieldInfo.getField().isAnnotationPresent(UpdateIgnore.class)) continue;
            String value = MysqlFieldValueConversion.updateModelConversion(entity, fieldInfo.getField());
            sqlBuilder.append("`").append(fieldInfo.getColumnName()).append("` = ").append(value).append(", ");
        }
        if (sqlBuilder.indexOf(",") != -1) {
            sqlBuilder.replace(sqlBuilder.length() - 2, sqlBuilder.length(), " ");
        }
        sqlBuilder.append("WHERE `").append(entityInfo.getPrimaryKey().getColumnName()).append("` = ").append(primaryKeyValue);
        return sqlBuilder.toString();
    }

    @Override
    public String toLocalUpdateSql(Object entity) {
        EntityInfo entityInfo = UniversalCrudContent.getEntityInfo(entity.getClass());
        String table = entityInfo.getTableName();
        String primaryKeyValue = this.checkPrimaryKeyAndGetValue(entity, entityInfo);
        StringBuilder sqlBuilder = new StringBuilder("UPDATE `" + table + "` SET ");
        List<EntityInfo.FieldInfo> fieldInfos = entityInfo.getFieldInfos();
        for (EntityInfo.FieldInfo fieldInfo : fieldInfos) {
            String value;
            if (fieldInfo.getField().isAnnotationPresent(UpdateIgnore.class) || (value = MysqlFieldValueConversion.updateModelConversion(entity, fieldInfo.getField())) == null) continue;
            sqlBuilder.append("`").append(fieldInfo.getColumnName()).append("` = ").append(value).append(", ");
        }
        if (sqlBuilder.indexOf(",") != -1) {
            sqlBuilder.replace(sqlBuilder.length() - 2, sqlBuilder.length(), " ");
        }
        sqlBuilder.append("WHERE `").append(entityInfo.getPrimaryKey().getColumnName()).append("` = ").append(primaryKeyValue);
        return sqlBuilder.toString();
    }
}

