/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.mybatis.session;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.apache.ibatis.session.Configuration;

public class UniversalCrudConfiguration
extends Configuration {
    private String universalCrudScan;

    public String getDriverClassName() {
        DataSource dataSource = this.getEnvironment().getDataSource();
        if (PooledDataSource.class.isAssignableFrom(dataSource.getClass())) {
            return ((PooledDataSource)dataSource).getDriver();
        }
        Method getDriverMethod = null;
        try {
            getDriverMethod = dataSource.getClass().getMethod("getDriverClassName", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e1) {
            return null;
        }
        try {
            return (String)getDriverMethod.invoke((Object)dataSource, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return null;
        }
    }

    public String getUniversalCrudScan() {
        return this.universalCrudScan;
    }

    public void setUniversalCrudScan(String universalCrudScan) {
        this.universalCrudScan = universalCrudScan;
    }
}

