/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.mybatis.session;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Properties;
import org.apache.ibatis.exceptions.ExceptionFactory;
import org.apache.ibatis.executor.ErrorContext;
import org.linuxprobe.crud.mybatis.session.UniversalCrudConfiguration;
import org.linuxprobe.crud.mybatis.session.UniversalCrudSqlSessionFactory;
import org.linuxprobe.crud.mybatis.session.builder.xml.UniversalCrudXMLConfigBuilder;
import org.linuxprobe.crud.mybatis.session.defaults.UniversalCrudDefaultSqlSessionFactory;

public class UniversalCrudSqlSessionFactoryBuilder {
    public UniversalCrudSqlSessionFactory build(Reader reader) {
        return this.build(reader, null, null);
    }

    public UniversalCrudSqlSessionFactory build(Reader reader, String environment) {
        return this.build(reader, environment, null);
    }

    public UniversalCrudSqlSessionFactory build(Reader reader, Properties properties) {
        return this.build(reader, null, properties);
    }

    public UniversalCrudSqlSessionFactory build(Reader reader, String environment, Properties properties) {
        try {
            UniversalCrudXMLConfigBuilder parser = new UniversalCrudXMLConfigBuilder(reader, environment, properties);
            UniversalCrudSqlSessionFactory universalCrudSqlSessionFactory = this.build(parser.parse());
            return universalCrudSqlSessionFactory;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException((String)"Error building SqlSession.", (Exception)e);
        }
        finally {
            ErrorContext.instance().reset();
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public UniversalCrudSqlSessionFactory build(InputStream inputStream) {
        return this.build(inputStream, null, null);
    }

    public UniversalCrudSqlSessionFactory build(InputStream inputStream, String environment) {
        return this.build(inputStream, environment, null);
    }

    public UniversalCrudSqlSessionFactory build(InputStream inputStream, Properties properties) {
        return this.build(inputStream, null, properties);
    }

    public UniversalCrudSqlSessionFactory build(InputStream inputStream, String environment, Properties properties) {
        try {
            UniversalCrudXMLConfigBuilder parser = new UniversalCrudXMLConfigBuilder(inputStream, environment, properties);
            UniversalCrudSqlSessionFactory universalCrudSqlSessionFactory = this.build(parser.parse());
            return universalCrudSqlSessionFactory;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException((String)"Error building SqlSession.", (Exception)e);
        }
        finally {
            ErrorContext.instance().reset();
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public UniversalCrudSqlSessionFactory build(UniversalCrudConfiguration config) {
        return new UniversalCrudDefaultSqlSessionFactory(config);
    }
}

