/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.modifycolumn;

import java.util.ArrayList;
import java.util.List;
import liquibase.change.AbstractChange;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.modifycolumn.ModifyColumnStatement;
import liquibase.statement.SqlStatement;
import liquibase.util.StringUtil;

@DatabaseChange(name="modifyColumn", description="Modify column definition", priority=1, appliesTo={"column"})
public class ModifyColumnChange
extends AbstractChange
implements ChangeWithColumns {
    private String schemaName;
    private String tableName;
    private List<ColumnConfig> columns = new ArrayList<ColumnConfig>();

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtil.trimToNull((String)schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    public void addColumn(ColumnConfig column) {
        this.columns.add(column);
    }

    public void setColumns(List columns) {
        this.columns = columns;
    }

    public void removeColumn(ColumnConfig column) {
        this.columns.remove(column);
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new ModifyColumnStatement(this.getSchemaName(), this.getTableName(), this.getColumns().toArray(new ColumnConfig[this.getColumns().size()]))};
    }

    public String getConfirmationMessage() {
        ArrayList<String> names = new ArrayList<String>(this.columns.size());
        for (ColumnConfig col : this.columns) {
            names.add(col.getName() + "(" + col.getType() + ")");
        }
        return "Columns " + StringUtil.join(names, (String)",") + " of " + this.getTableName() + " modified";
    }
}

