/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mssql.change;

import java.util.ArrayList;
import java.util.Arrays;
import liquibase.change.DatabaseChange;
import liquibase.change.core.LoadDataChange;
import liquibase.database.Database;
import liquibase.ext.mssql.MssqlUtil;
import liquibase.statement.ExecutablePreparedStatementBase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertSetStatement;
import liquibase.statement.core.RawSqlStatement;

@DatabaseChange(name="loadData", description="", priority=5)
public class LoadDataChangeMssql
extends LoadDataChange {
    public SqlStatement[] generateStatements(Database database) {
        String tableName;
        String schemaName;
        String catalogName;
        ArrayList<SqlStatement> returnList = new ArrayList<SqlStatement>(Arrays.asList(super.generateStatements(database)));
        SqlStatement untypedStatement = (SqlStatement)returnList.get(0);
        if (untypedStatement instanceof ExecutablePreparedStatementBase) {
            ExecutablePreparedStatementBase statement = (ExecutablePreparedStatementBase)untypedStatement;
            catalogName = statement.getCatalogName();
            schemaName = statement.getSchemaName();
            tableName = statement.getTableName();
        } else if (untypedStatement instanceof InsertSetStatement) {
            InsertSetStatement statement = (InsertSetStatement)untypedStatement;
            catalogName = statement.getCatalogName();
            schemaName = statement.getSchemaName();
            tableName = statement.getTableName();
        } else {
            throw new RuntimeException("Unexpected statement type: " + untypedStatement.getClass().getName());
        }
        returnList.add(0, (SqlStatement)new RawSqlStatement(MssqlUtil.generateIdentityInsertSql("ON", catalogName, schemaName, tableName, database)));
        returnList.add((SqlStatement)new RawSqlStatement(MssqlUtil.generateIdentityInsertSql("OFF", catalogName, schemaName, tableName, database)));
        return returnList.toArray(new SqlStatement[0]);
    }
}

