/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mssql.sqlgenerator;

import java.util.ArrayList;
import java.util.Arrays;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.ext.mssql.MssqlUtil;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertStatement;
import liquibase.structure.DatabaseObject;

public class InsertGenerator
extends liquibase.sqlgenerator.core.InsertGenerator {
    public int getPriority() {
        return 15;
    }

    public boolean supports(InsertStatement statement, Database database) {
        return database instanceof MSSQLDatabase;
    }

    public ValidationErrors validate(InsertStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        return sqlGeneratorChain.validate((SqlStatement)statement, database);
    }

    public Sql[] generateSql(InsertStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ArrayList<Sql> sql = new ArrayList<Sql>(Arrays.asList(sqlGeneratorChain.generateSql((SqlStatement)statement, database)));
        sql.add(0, (Sql)new UnparsedSql(MssqlUtil.generateIdentityInsertSql("ON", statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), database), new DatabaseObject[0]));
        sql.add((Sql)new UnparsedSql(MssqlUtil.generateIdentityInsertSql("OFF", statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), database), new DatabaseObject[0]));
        return sql.toArray(new Sql[sql.size()]);
    }
}

