/*
 * Decompiled with CFR 0.152.
 */
package liquibase;

import java.io.InputStream;
import java.net.URL;
import java.sql.DatabaseMetaData;
import java.util.Enumeration;
import java.util.List;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.easymock.classextension.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LiquibaseTest {
    private TestLiquibase testLiquibase;
    private DatabaseConnection connectionForConstructor;

    @Before
    public void setUp() throws Exception {
        if (this.connectionForConstructor != null) {
            EasyMock.reset((Object)this.connectionForConstructor);
        }
        this.connectionForConstructor = (DatabaseConnection)EasyMock.createMock(DatabaseConnection.class);
        this.connectionForConstructor.setAutoCommit(false);
        org.easymock.EasyMock.expectLastCall().atLeastOnce();
        DatabaseMetaData metaData = (DatabaseMetaData)EasyMock.createMock(DatabaseMetaData.class);
        org.easymock.EasyMock.expect((Object)metaData.getDatabaseProductName()).andReturn((Object)"Oracle");
        EasyMock.replay((Object)metaData);
        EasyMock.replay((Object)this.connectionForConstructor);
        this.testLiquibase = new TestLiquibase();
    }

    @Test
    public void getImplementedDatabases() throws Exception {
        List databases = DatabaseFactory.getInstance().getImplementedDatabases();
        Assert.assertTrue((databases.size() > 15 ? 1 : 0) != 0);
        boolean foundOracle = false;
        boolean foundPostgres = false;
        boolean foundMSSQL = false;
        for (Database db : databases) {
            if (db instanceof OracleDatabase) {
                foundOracle = true;
                continue;
            }
            if (db instanceof PostgresDatabase) {
                foundPostgres = true;
                continue;
            }
            if (!(db instanceof MSSQLDatabase)) continue;
            foundMSSQL = true;
        }
        Assert.assertTrue((String)"Oracle not in Implemented Databases", (boolean)foundOracle);
        Assert.assertTrue((String)"MSSQL not in Implemented Databases", (boolean)foundMSSQL);
        Assert.assertTrue((String)"Postgres not in Implemented Databases", (boolean)foundPostgres);
    }

    private class TestLiquibase
    extends Liquibase {
        private String url;
        private InputStream inputStream;

        public TestLiquibase() throws LiquibaseException {
            super("liquibase/test.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), (Database)null);
            this.inputStream = (InputStream)EasyMock.createMock(InputStream.class);
            EasyMock.replay((Object)this.inputStream);
        }

        public Database getDatabase() {
            if (this.database == null) {
                this.database = new OracleDatabase(){};
            }
            return this.database;
        }

        public void setDatabase(Database database) {
            this.database = database;
        }

        public Database[] getImplementedDatabases() {
            Database mockDatabase = (Database)EasyMock.createMock(Database.class);
            try {
                org.easymock.EasyMock.expect((Object)mockDatabase.isCorrectDatabaseImplementation(null)).andReturn((Object)true).atLeastOnce();
                mockDatabase.setConnection((DatabaseConnection)null);
                org.easymock.EasyMock.expectLastCall();
                org.easymock.EasyMock.expect((Object)mockDatabase.getConnection()).andReturn((Object)LiquibaseTest.this.connectionForConstructor);
                EasyMock.replay((Object)mockDatabase);
                return new Database[]{mockDatabase};
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public ResourceAccessor getFileOpener() {
            return new ResourceAccessor(){

                public InputStream getResourceAsStream(String file) {
                    return TestLiquibase.this.inputStream;
                }

                public Enumeration<URL> getResources(String packageName) {
                    return null;
                }

                public ClassLoader toClassLoader() {
                    return null;
                }
            };
        }
    }
}

