/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.CheckSum;
import liquibase.change.ColumnConfig;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.serializer.core.string.StringChangeLogSerializer;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SqlStatement;
import liquibase.test.TestContext;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChangeTest {
    @Test
    public abstract void getRefactoringName() throws Exception;

    @Test
    public abstract void generateStatement() throws Exception;

    @Test
    public abstract void getConfirmationMessage() throws Exception;

    @Test
    public void generateCheckSum() throws Exception {
        Change change = this.createClassUnderTest();
        if (change == null) {
            return;
        }
        CheckSum checkSum = change.generateCheckSum();
        Assert.assertNotNull((Object)checkSum);
        Assert.assertEquals((long)CheckSum.getCurrentVersion(), (long)checkSum.getVersion());
        Assert.assertTrue((boolean)checkSum.toString().startsWith(CheckSum.getCurrentVersion() + ":"));
        HashMap<String, String> seenCheckSums = new HashMap<String, String>();
        for (Field field : change.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (field.getName().startsWith("$VR") || field.getName().equals("serialVersionUID") || field.getName().equals("associatedWith")) continue;
            if (String.class.isAssignableFrom(field.getType())) {
                field.set(change, "asdghasdgasdg");
                this.checkThatChecksumIsNew(change, seenCheckSums, field);
                field.set(change, "gsgasdgasdggasdg sdg a");
                this.checkThatChecksumIsNew(change, seenCheckSums, field);
                continue;
            }
            if (Boolean.class.isAssignableFrom(field.getType())) {
                field.set(change, Boolean.TRUE);
                this.checkThatChecksumIsNew(change, seenCheckSums, field);
                field.set(change, Boolean.FALSE);
                this.checkThatChecksumIsNew(change, seenCheckSums, field);
                continue;
            }
            if (Integer.class.isAssignableFrom(field.getType())) {
                field.set(change, 6532);
                this.checkThatChecksumIsNew(change, seenCheckSums, field);
                field.set(change, -52352);
                this.checkThatChecksumIsNew(change, seenCheckSums, field);
                continue;
            }
            if (DatabaseFunction.class.isAssignableFrom(field.getType())) {
                field.set(change, new DatabaseFunction("FUNC1"));
                this.checkThatChecksumIsNew(change, seenCheckSums, field);
                field.set(change, new DatabaseFunction("FUNC 2"));
                this.checkThatChecksumIsNew(change, seenCheckSums, field);
                continue;
            }
            if (BigInteger.class.isAssignableFrom(field.getType())) {
                field.set(change, new BigInteger("6532"));
                this.checkThatChecksumIsNew(change, seenCheckSums, field);
                field.set(change, new BigInteger("-52352"));
                this.checkThatChecksumIsNew(change, seenCheckSums, field);
                continue;
            }
            if (List.class.isAssignableFrom(field.getType())) {
                ColumnConfig column1 = new ColumnConfig();
                ((List)field.get(change)).add(column1);
                column1.setName("ghsdgasdg");
                this.checkThatChecksumIsNew(change, seenCheckSums, field);
                column1.setType("gasdgasdg");
                this.checkThatChecksumIsNew(change, seenCheckSums, field);
                ColumnConfig column2 = new ColumnConfig();
                ((List)field.get(change)).add(column2);
                column2.setName("87682346asgasdg");
                this.checkThatChecksumIsNew(change, seenCheckSums, field);
                continue;
            }
            if (field.getName().equalsIgnoreCase("changeLogParameters")) continue;
            throw new RuntimeException("Unknown field type: " + field.getType() + " for " + field.getName());
        }
    }

    private Change createClassUnderTest() throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        String className = this.getClass().getName().replaceAll("Test$", "");
        if (className.indexOf("Abstract") > 0) {
            return null;
        }
        return (Change)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    protected void checkThatChecksumIsNew(Change change, Map<String, String> seenCheckSums, Field field) {
        String serialized = new StringChangeLogSerializer().serialize(change);
        CheckSum newCheckSum = change.generateCheckSum();
        if (seenCheckSums.containsKey(newCheckSum.toString())) {
            Assert.fail((String)("generated duplicate checksum channging " + field.getName() + "\n" + serialized + "\nmatches\n" + seenCheckSums.get(newCheckSum.toString())));
        }
        seenCheckSums.put(newCheckSum.toString(), serialized);
    }

    protected void testChangeOnAllExcept(Change change, GenerateAllValidator validator, Class<? extends Database> ... databases) throws Exception {
        ArrayList databsesToRun = new ArrayList();
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            List<Class<? extends Database>> databaseClasses = Arrays.asList(databases);
            if (databaseClasses.contains(database.getClass())) continue;
            databsesToRun.add(database.getClass());
        }
        this.testChange(change, validator, databsesToRun.toArray(new Class[databsesToRun.size()]));
    }

    protected void testChangeOnAll(Change change, GenerateAllValidator validator) throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            SqlStatement[] sqlStatements = change.generateStatements(database);
            try {
                validator.validate(sqlStatements, database);
            }
            catch (AssertionError e) {
                AssertionError error = new AssertionError((Object)("GenerateAllValidator failed for " + database.getTypeName() + ": " + ((Throwable)((Object)e)).getMessage()));
                ((Throwable)((Object)error)).setStackTrace(((Throwable)((Object)e)).getStackTrace());
                throw error;
            }
        }
    }

    protected void testChange(Change change, GenerateAllValidator validator, Class<? extends Database> ... databases) throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            List<Class<? extends Database>> databaseClasses = Arrays.asList(databases);
            if (!databaseClasses.contains(database.getClass())) continue;
            SqlStatement[] sqlStatements = change.generateStatements(database);
            try {
                validator.validate(sqlStatements, database);
            }
            catch (AssertionError e) {
                AssertionError error = new AssertionError((Object)("GenerateAllValidator failed for " + database.getTypeName() + ": " + ((Throwable)((Object)e)).getMessage()));
                ((Throwable)((Object)error)).setStackTrace(((Throwable)((Object)e)).getStackTrace());
                throw error;
            }
        }
    }

    protected void testInverseOnAllExcept(AbstractChange change, InverseValidator validator, Class<? extends Database> ... databases) throws Exception {
        ArrayList databsesToRun = new ArrayList();
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            List<Class<? extends Database>> databaseClasses = Arrays.asList(databases);
            if (databaseClasses.contains(database.getClass())) continue;
            databsesToRun.add(database.getClass());
        }
        this.testInverse(change, validator, databsesToRun.toArray(new Class[databsesToRun.size()]));
    }

    protected void testInverseOnAll(AbstractChange change, InverseValidator validator) throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            Change[] inverses = change.createInverses();
            try {
                validator.validate(inverses);
            }
            catch (AssertionError e) {
                AssertionError error = new AssertionError((Object)("InverseValidator failed for " + database.getTypeName() + ": " + ((Throwable)((Object)e)).getMessage()));
                ((Throwable)((Object)error)).setStackTrace(((Throwable)((Object)e)).getStackTrace());
                throw error;
            }
        }
    }

    protected void testInverse(AbstractChange change, InverseValidator validator, Class<? extends Database> ... databases) throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            List<Class<? extends Database>> databaseClasses = Arrays.asList(databases);
            if (!databaseClasses.contains(database.getClass())) continue;
            Change[] inverses = change.createInverses();
            try {
                validator.validate(inverses);
            }
            catch (AssertionError e) {
                AssertionError error = new AssertionError((Object)("InverseValidator failed for " + database.getTypeName() + ": " + ((Throwable)((Object)e)).getMessage()));
                ((Throwable)((Object)error)).setStackTrace(((Throwable)((Object)e)).getStackTrace());
                throw error;
            }
        }
    }

    @Test
    public void isSupported() throws Exception {
        Change change = this.createClassUnderTest();
        if (change == null) {
            return;
        }
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            Assert.assertEquals((String)("Unexpected availablity on " + database.getTypeName()), (Object)(!this.changeIsUnsupported(database) ? 1 : 0), (Object)change.supports(database));
        }
    }

    protected boolean changeIsUnsupported(Database database) {
        return false;
    }

    @Test
    public void validate() throws Exception {
        Change change = this.createClassUnderTest();
        if (change == null) {
            return;
        }
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!change.supports(database)) continue;
            ValidationErrors validationErrors = change.validate(database);
            Assert.assertTrue((String)("no errors found for " + database.getClass().getName()), (boolean)validationErrors.hasErrors());
        }
    }

    protected static interface InverseValidator {
        public void validate(Change[] var1);
    }

    protected static interface GenerateAllValidator {
        public void validate(SqlStatement[] var1, Database var2);
    }
}

