/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import liquibase.change.CheckSum;
import org.junit.Assert;
import org.junit.Test;

public class CheckSumTest {
    @Test
    public void testCompute_String() {
        String valueToHash = "asdf";
        CheckSum checkSum = CheckSum.compute((String)valueToHash);
        Assert.assertEquals((long)CheckSum.getCurrentVersion(), (long)checkSum.getVersion());
        Assert.assertFalse((boolean)checkSum.toString().equals(valueToHash));
    }

    @Test
    public void testCompute_Stream() {
        String valueToHash = "asdf";
        CheckSum checkSum = CheckSum.compute((InputStream)new ByteArrayInputStream(valueToHash.getBytes()));
        Assert.assertEquals((long)CheckSum.getCurrentVersion(), (long)checkSum.getVersion());
        Assert.assertFalse((boolean)checkSum.toString().equals(valueToHash));
        Assert.assertEquals((Object)CheckSum.compute((String)valueToHash).toString(), (Object)checkSum.toString());
    }

    @Test
    public void parse_v2() {
        String checksumString = "2:asdf";
        CheckSum checkSum = CheckSum.parse((String)checksumString);
        Assert.assertEquals((long)2L, (long)checkSum.getVersion());
        Assert.assertEquals((Object)checksumString, (Object)checksumString);
    }

    @Test
    public void parse_v1() {
        String checksumString = "asdf";
        CheckSum checkSum = CheckSum.parse((String)checksumString);
        Assert.assertEquals((long)1L, (long)checkSum.getVersion());
        Assert.assertEquals((Object)"1:asdf", (Object)checkSum.toString());
    }
}

