/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChangeTest;
import liquibase.change.Change;
import liquibase.change.core.AddAutoIncrementChange;
import liquibase.database.Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddAutoIncrementStatement;
import liquibase.statement.core.AddDefaultValueStatement;
import liquibase.statement.core.CreateSequenceStatement;
import liquibase.statement.core.SetNullableStatement;
import org.junit.Assert;
import org.junit.Test;

public class AddAutoIncrementChangeTest
extends AbstractChangeTest {
    @Test
    public void constructor() {
        AddAutoIncrementChange change = new AddAutoIncrementChange();
        Assert.assertEquals((Object)"addAutoIncrement", (Object)change.getChangeMetaData().getName());
        Assert.assertEquals((Object)"Set Column as Auto-Increment", (Object)change.getChangeMetaData().getDescription());
    }

    @Test
    public void generateStatement() throws Exception {
        AddAutoIncrementChange change = new AddAutoIncrementChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TABLE_NAME");
        change.setColumnName("COLUMN_NAME");
        change.setColumnDataType("DATATYPE(255)");
        this.testChangeOnAllExcept((Change)change, new AbstractChangeTest.GenerateAllValidator(){

            public void validate(SqlStatement[] sqlStatements, Database database) {
                Assert.assertEquals((long)1L, (long)sqlStatements.length);
                Assert.assertTrue((boolean)(sqlStatements[0] instanceof AddAutoIncrementStatement));
                Assert.assertEquals((Object)"SCHEMA_NAME", (Object)((AddAutoIncrementStatement)sqlStatements[0]).getSchemaName());
                Assert.assertEquals((Object)"TABLE_NAME", (Object)((AddAutoIncrementStatement)sqlStatements[0]).getTableName());
                Assert.assertEquals((Object)"COLUMN_NAME", (Object)((AddAutoIncrementStatement)sqlStatements[0]).getColumnName());
                Assert.assertEquals((Object)"DATATYPE(255)", (Object)((AddAutoIncrementStatement)sqlStatements[0]).getColumnDataType());
            }
        }, PostgresDatabase.class);
        this.testChange((Change)change, new AbstractChangeTest.GenerateAllValidator(){

            public void validate(SqlStatement[] sqlStatements, Database database) {
                Assert.assertEquals((long)3L, (long)sqlStatements.length);
                Assert.assertTrue((boolean)(sqlStatements[0] instanceof CreateSequenceStatement));
                Assert.assertTrue((boolean)(sqlStatements[1] instanceof SetNullableStatement));
                Assert.assertTrue((boolean)(sqlStatements[2] instanceof AddDefaultValueStatement));
            }
        }, PostgresDatabase.class);
    }

    @Test
    public void getRefactoringName() throws Exception {
        Assert.assertEquals((Object)"Set Column as Auto-Increment", (Object)new AddAutoIncrementChange().getChangeMetaData().getDescription());
    }

    @Test
    public void getConfirmationMessage() throws Exception {
        AddAutoIncrementChange change = new AddAutoIncrementChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TABLE_NAME");
        change.setColumnName("COLUMN_NAME");
        change.setColumnDataType("DATATYPE(255)");
        Assert.assertEquals((Object)"Auto-increment added to TABLE_NAME.COLUMN_NAME", (Object)change.getConfirmationMessage());
    }

    protected boolean changeIsUnsupported(Database database) {
        return !database.supportsAutoIncrement() || database instanceof MSSQLDatabase || database instanceof DerbyDatabase;
    }
}

