/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.math.BigInteger;
import liquibase.change.AbstractChange;
import liquibase.change.AbstractChangeTest;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.core.AddColumnChange;
import liquibase.change.core.DropColumnChange;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.statement.ColumnConstraint;
import liquibase.statement.ForeignKeyConstraint;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddColumnStatement;
import liquibase.statement.core.ReorganizeTableStatement;
import liquibase.statement.core.UpdateStatement;
import org.junit.Assert;
import org.junit.Test;

public class AddColumnChangeTest
extends AbstractChangeTest {
    public void validate() throws Exception {
        super.validate();
    }

    @Test
    public void getRefactoringName() throws Exception {
        AddColumnChange refactoring = new AddColumnChange();
        Assert.assertEquals((Object)"Add Column", (Object)refactoring.getChangeMetaData().getDescription());
    }

    @Test
    public void addColumn() throws Exception {
        AddColumnChange change = new AddColumnChange();
        Assert.assertEquals((long)0L, (long)change.getColumns().size());
        change.addColumn(new ColumnConfig().setName("a"));
        Assert.assertEquals((long)1L, (long)change.getColumns().size());
        change.addColumn(new ColumnConfig().setName("b"));
        Assert.assertEquals((long)2L, (long)change.getColumns().size());
    }

    @Test
    public void removeColumn() throws Exception {
        ColumnConfig columnA = new ColumnConfig().setName("a");
        ColumnConfig columnB = new ColumnConfig().setName("b");
        AddColumnChange change = new AddColumnChange();
        Assert.assertEquals((long)0L, (long)change.getColumns().size());
        change.removeColumn(columnA);
        Assert.assertEquals((long)0L, (long)change.getColumns().size());
        change.addColumn(columnA);
        Assert.assertEquals((long)1L, (long)change.getColumns().size());
        change.removeColumn(columnB);
        Assert.assertEquals((long)1L, (long)change.getColumns().size());
        change.removeColumn(columnA);
        Assert.assertEquals((long)0L, (long)change.getColumns().size());
    }

    @Test
    public void generateStatement() throws Exception {
        AddColumnChange refactoring = new AddColumnChange();
        refactoring.setSchemaName("SCHEMA");
        refactoring.setTableName("TAB");
        ColumnConfig column = new ColumnConfig();
        column.setName("NEWCOL");
        column.setType("TYP");
        ConstraintsConfig constraints = new ConstraintsConfig();
        constraints.setNullable(Boolean.FALSE);
        column.setConstraints(constraints);
        refactoring.addColumn(column);
        column = new ColumnConfig();
        column.setName("NEWCOL2");
        column.setType("TYP2");
        column.setConstraints(new ConstraintsConfig());
        refactoring.addColumn(column);
        this.testChangeOnAll((Change)refactoring, new AbstractChangeTest.GenerateAllValidator(){

            public void validate(SqlStatement[] sqlStatements, Database database) {
                if (database instanceof DB2Database) {
                    Assert.assertEquals((long)4L, (long)sqlStatements.length);
                    Assert.assertTrue((boolean)(sqlStatements[0] instanceof AddColumnStatement));
                    Assert.assertTrue((boolean)(sqlStatements[1] instanceof ReorganizeTableStatement));
                    Assert.assertTrue((boolean)(sqlStatements[2] instanceof AddColumnStatement));
                    Assert.assertTrue((boolean)(sqlStatements[3] instanceof ReorganizeTableStatement));
                } else {
                    Assert.assertEquals((long)2L, (long)sqlStatements.length);
                    Assert.assertTrue((boolean)(sqlStatements[0] instanceof AddColumnStatement));
                    Assert.assertTrue((boolean)(sqlStatements[1] instanceof AddColumnStatement));
                }
                AddColumnStatement firstAddColumnStatement = (AddColumnStatement)sqlStatements[0];
                AddColumnStatement secondAddColumnStatement = null;
                secondAddColumnStatement = database instanceof DB2Database ? (AddColumnStatement)sqlStatements[2] : (AddColumnStatement)sqlStatements[1];
                Assert.assertEquals((Object)"SCHEMA", (Object)firstAddColumnStatement.getSchemaName());
                Assert.assertEquals((Object)"TAB", (Object)firstAddColumnStatement.getTableName());
                Assert.assertEquals((Object)"NEWCOL", (Object)firstAddColumnStatement.getColumnName());
                Assert.assertEquals((Object)"TYP", (Object)firstAddColumnStatement.getColumnType());
                Assert.assertFalse((boolean)firstAddColumnStatement.isPrimaryKey());
                Assert.assertFalse((boolean)firstAddColumnStatement.isNullable());
                Assert.assertEquals((Object)"SCHEMA", (Object)secondAddColumnStatement.getSchemaName());
                Assert.assertEquals((Object)"TAB", (Object)secondAddColumnStatement.getTableName());
                Assert.assertEquals((Object)"NEWCOL2", (Object)secondAddColumnStatement.getColumnName());
                Assert.assertEquals((Object)"TYP2", (Object)secondAddColumnStatement.getColumnType());
                Assert.assertTrue((boolean)secondAddColumnStatement.isNullable());
            }
        });
    }

    @Test
    public void generateStatement_nullable() throws Exception {
        AddColumnChange refactoring = new AddColumnChange();
        refactoring.setSchemaName("SCHEMA");
        refactoring.setTableName("TAB");
        ColumnConfig column = new ColumnConfig();
        column.setName("NEWCOL");
        column.setType("TYP");
        ConstraintsConfig constraints = new ConstraintsConfig();
        constraints.setNullable(Boolean.TRUE);
        column.setConstraints(constraints);
        refactoring.addColumn(column);
        this.testChangeOnAll((Change)refactoring, new AbstractChangeTest.GenerateAllValidator(){

            public void validate(SqlStatement[] sqlStatements, Database database) {
                if (database instanceof DB2Database) {
                    Assert.assertEquals((long)2L, (long)sqlStatements.length);
                    Assert.assertTrue((boolean)(sqlStatements[0] instanceof AddColumnStatement));
                    Assert.assertTrue((boolean)(sqlStatements[1] instanceof ReorganizeTableStatement));
                } else {
                    Assert.assertEquals((long)1L, (long)sqlStatements.length);
                    Assert.assertTrue((boolean)(sqlStatements[0] instanceof AddColumnStatement));
                }
                Assert.assertEquals((Object)"SCHEMA", (Object)((AddColumnStatement)sqlStatements[0]).getSchemaName());
                Assert.assertEquals((Object)"TAB", (Object)((AddColumnStatement)sqlStatements[0]).getTableName());
                Assert.assertEquals((Object)"NEWCOL", (Object)((AddColumnStatement)sqlStatements[0]).getColumnName());
                Assert.assertEquals((Object)"TYP", (Object)((AddColumnStatement)sqlStatements[0]).getColumnType());
                Assert.assertFalse((boolean)((AddColumnStatement)sqlStatements[0]).isPrimaryKey());
                Assert.assertTrue((boolean)((AddColumnStatement)sqlStatements[0]).isNullable());
            }
        });
    }

    @Test
    public void generateStatement_notNull() throws Exception {
        AddColumnChange refactoring = new AddColumnChange();
        refactoring.setSchemaName("SCHEMA");
        refactoring.setTableName("TAB");
        ColumnConfig column = new ColumnConfig();
        column.setName("NEWCOL");
        column.setType("TYP");
        ConstraintsConfig constraints = new ConstraintsConfig();
        constraints.setNullable(Boolean.FALSE);
        column.setConstraints(constraints);
        refactoring.addColumn(column);
        this.testChangeOnAll((Change)refactoring, new AbstractChangeTest.GenerateAllValidator(){

            public void validate(SqlStatement[] sqlStatements, Database database) {
                if (database instanceof DB2Database) {
                    Assert.assertEquals((long)2L, (long)sqlStatements.length);
                    Assert.assertTrue((boolean)(sqlStatements[0] instanceof AddColumnStatement));
                    Assert.assertTrue((boolean)(sqlStatements[1] instanceof ReorganizeTableStatement));
                } else {
                    Assert.assertEquals((long)1L, (long)sqlStatements.length);
                    Assert.assertTrue((boolean)(sqlStatements[0] instanceof AddColumnStatement));
                }
                Assert.assertEquals((Object)"SCHEMA", (Object)((AddColumnStatement)sqlStatements[0]).getSchemaName());
                Assert.assertEquals((Object)"TAB", (Object)((AddColumnStatement)sqlStatements[0]).getTableName());
                Assert.assertEquals((Object)"NEWCOL", (Object)((AddColumnStatement)sqlStatements[0]).getColumnName());
                Assert.assertEquals((Object)"TYP", (Object)((AddColumnStatement)sqlStatements[0]).getColumnType());
                Assert.assertFalse((boolean)((AddColumnStatement)sqlStatements[0]).isPrimaryKey());
                Assert.assertFalse((boolean)((AddColumnStatement)sqlStatements[0]).isNullable());
            }
        });
    }

    @Test
    public void generateStatement_primaryKey() throws Exception {
        AddColumnChange refactoring = new AddColumnChange();
        refactoring.setSchemaName("SCHEMA");
        refactoring.setTableName("TAB");
        ColumnConfig column = new ColumnConfig();
        column.setName("NEWCOL");
        column.setType("TYP");
        ConstraintsConfig constraints = new ConstraintsConfig();
        constraints.setNullable(Boolean.FALSE);
        constraints.setPrimaryKey(Boolean.TRUE);
        column.setConstraints(constraints);
        refactoring.addColumn(column);
        this.testChangeOnAll((Change)refactoring, new AbstractChangeTest.GenerateAllValidator(){

            public void validate(SqlStatement[] sqlStatements, Database database) {
                if (database instanceof DB2Database) {
                    Assert.assertEquals((long)2L, (long)sqlStatements.length);
                    Assert.assertTrue((boolean)(sqlStatements[0] instanceof AddColumnStatement));
                    Assert.assertTrue((boolean)(sqlStatements[1] instanceof ReorganizeTableStatement));
                } else {
                    Assert.assertEquals((long)1L, (long)sqlStatements.length);
                    Assert.assertTrue((boolean)(sqlStatements[0] instanceof AddColumnStatement));
                }
                Assert.assertTrue((boolean)((AddColumnStatement)sqlStatements[0]).isPrimaryKey());
            }
        });
    }

    @Test
    public void generateStatement_foreignKey() throws Exception {
        AddColumnChange refactoring = new AddColumnChange();
        refactoring.setSchemaName("SCHEMA");
        refactoring.setTableName("TAB");
        ColumnConfig column = new ColumnConfig();
        column.setName("NEWCOL");
        column.setType("TYP");
        ConstraintsConfig constraints = new ConstraintsConfig();
        constraints.setNullable(Boolean.FALSE);
        constraints.setPrimaryKey(Boolean.TRUE);
        constraints.setForeignKeyName("fk_name");
        constraints.setReferences("ref_table(id)");
        column.setConstraints(constraints);
        refactoring.addColumn(column);
        this.testChangeOnAll((Change)refactoring, new AbstractChangeTest.GenerateAllValidator(){

            public void validate(SqlStatement[] sqlStatements, Database database) {
                if (database instanceof DB2Database) {
                    Assert.assertEquals((long)2L, (long)sqlStatements.length);
                    Assert.assertTrue((boolean)(sqlStatements[0] instanceof AddColumnStatement));
                    Assert.assertTrue((boolean)(sqlStatements[1] instanceof ReorganizeTableStatement));
                } else {
                    Assert.assertEquals((long)1L, (long)sqlStatements.length);
                    Assert.assertTrue((boolean)(sqlStatements[0] instanceof AddColumnStatement));
                }
                Assert.assertTrue((boolean)((AddColumnStatement)sqlStatements[0]).isPrimaryKey());
                boolean foundFkInfo = false;
                for (ColumnConstraint constraint : ((AddColumnStatement)sqlStatements[0]).getConstraints()) {
                    if (!(constraint instanceof ForeignKeyConstraint)) continue;
                    foundFkInfo = true;
                }
                Assert.assertTrue((String)"Did not find foreign key info", (boolean)foundFkInfo);
            }
        });
    }

    @Test
    public void generateStatement_withDefaultValue() throws Exception {
        AddColumnChange refactoring = new AddColumnChange();
        refactoring.setSchemaName("SCHEMA");
        refactoring.setTableName("TAB");
        ColumnConfig column = new ColumnConfig();
        column.setName("NEWCOL");
        column.setType("TYP");
        column.setValue("SOME VALUE");
        ConstraintsConfig constraints = new ConstraintsConfig();
        constraints.setNullable(Boolean.FALSE);
        constraints.setPrimaryKey(Boolean.TRUE);
        column.setAutoIncrement(Boolean.TRUE);
        column.setConstraints(constraints);
        refactoring.addColumn(column);
        this.testChangeOnAll((Change)refactoring, new AbstractChangeTest.GenerateAllValidator(){

            public void validate(SqlStatement[] sqlStatements, Database database) {
                if (database instanceof DB2Database) {
                    Assert.assertEquals((long)3L, (long)sqlStatements.length);
                    Assert.assertTrue((boolean)(sqlStatements[0] instanceof AddColumnStatement));
                    Assert.assertTrue((boolean)(sqlStatements[1] instanceof ReorganizeTableStatement));
                    Assert.assertTrue((boolean)(sqlStatements[2] instanceof UpdateStatement));
                } else {
                    Assert.assertEquals((long)2L, (long)sqlStatements.length);
                    Assert.assertTrue((boolean)(sqlStatements[0] instanceof AddColumnStatement));
                    Assert.assertTrue((boolean)(sqlStatements[1] instanceof UpdateStatement));
                }
                Assert.assertTrue((boolean)((AddColumnStatement)sqlStatements[0]).isPrimaryKey());
                Assert.assertTrue((boolean)((AddColumnStatement)sqlStatements[0]).isAutoIncrement());
                Assert.assertEquals((Object)"TAB", (Object)((UpdateStatement)sqlStatements[sqlStatements.length - 1]).getTableName());
                Assert.assertEquals((Object)"SOME VALUE", ((UpdateStatement)sqlStatements[sqlStatements.length - 1]).getNewColumnValues().get("NEWCOL"));
            }
        });
    }

    @Test
    public void generateStatement_autoIncrement() throws Exception {
        AddColumnChange refactoring = new AddColumnChange();
        refactoring.setSchemaName("SCHEMA");
        refactoring.setTableName("TAB");
        ColumnConfig column = new ColumnConfig();
        column.setName("NEWCOL");
        column.setType("TYP");
        ConstraintsConfig constraints = new ConstraintsConfig();
        constraints.setNullable(Boolean.FALSE);
        constraints.setPrimaryKey(Boolean.TRUE);
        column.setAutoIncrement(Boolean.TRUE);
        column.setStartWith(BigInteger.valueOf(2L));
        column.setIncrementBy(BigInteger.TEN);
        column.setConstraints(constraints);
        refactoring.addColumn(column);
        this.testChangeOnAll((Change)refactoring, new AbstractChangeTest.GenerateAllValidator(){

            public void validate(SqlStatement[] sqlStatements, Database database) {
                if (database instanceof DB2Database) {
                    Assert.assertEquals((long)2L, (long)sqlStatements.length);
                    Assert.assertTrue((boolean)(sqlStatements[0] instanceof AddColumnStatement));
                    Assert.assertTrue((boolean)(sqlStatements[1] instanceof ReorganizeTableStatement));
                } else {
                    Assert.assertEquals((long)1L, (long)sqlStatements.length);
                    Assert.assertTrue((boolean)(sqlStatements[0] instanceof AddColumnStatement));
                }
                Assert.assertTrue((boolean)((AddColumnStatement)sqlStatements[0]).isPrimaryKey());
                Assert.assertTrue((boolean)((AddColumnStatement)sqlStatements[0]).isAutoIncrement());
                Assert.assertNotNull((Object)((AddColumnStatement)sqlStatements[0]).getAutoIncrementConstraint());
                Assert.assertEquals((Object)BigInteger.valueOf(2L), (Object)((AddColumnStatement)sqlStatements[0]).getAutoIncrementConstraint().getStartWith());
                Assert.assertEquals((Object)BigInteger.TEN, (Object)((AddColumnStatement)sqlStatements[0]).getAutoIncrementConstraint().getIncrementBy());
            }
        });
    }

    @Test
    public void createInverses_singleColumn() throws Exception {
        AddColumnChange refactoring = new AddColumnChange();
        refactoring.setSchemaName("SCHEMA");
        refactoring.setTableName("TAB");
        ColumnConfig column = new ColumnConfig();
        column.setName("NEWCOL");
        column.setType("TYP");
        ConstraintsConfig constraints = new ConstraintsConfig();
        constraints.setNullable(Boolean.FALSE);
        constraints.setPrimaryKey(Boolean.TRUE);
        column.setAutoIncrement(Boolean.TRUE);
        column.setConstraints(constraints);
        refactoring.addColumn(column);
        this.testInverseOnAll((AbstractChange)refactoring, new AbstractChangeTest.InverseValidator(){

            public void validate(Change[] changes) {
                Assert.assertEquals((long)1L, (long)changes.length);
                Assert.assertTrue((boolean)(changes[0] instanceof DropColumnChange));
                Assert.assertEquals((Object)"TAB", (Object)((DropColumnChange)changes[0]).getTableName());
                Assert.assertEquals((Object)"NEWCOL", (Object)((DropColumnChange)changes[0]).getColumnName());
            }
        });
    }

    @Test
    public void createInverses_multiColumn() throws Exception {
        AddColumnChange refactoring = new AddColumnChange();
        refactoring.setSchemaName("SCHEMA");
        refactoring.setTableName("TAB");
        ColumnConfig column = new ColumnConfig();
        column.setName("NEWCOL");
        column.setType("TYP");
        ConstraintsConfig constraints = new ConstraintsConfig();
        constraints.setNullable(Boolean.FALSE);
        constraints.setPrimaryKey(Boolean.TRUE);
        column.setAutoIncrement(Boolean.TRUE);
        column.setConstraints(constraints);
        refactoring.addColumn(column);
        column = new ColumnConfig();
        column.setName("NEWCOL2");
        column.setType("TYP");
        refactoring.addColumn(column);
        this.testInverseOnAll((AbstractChange)refactoring, new AbstractChangeTest.InverseValidator(){

            public void validate(Change[] changes) {
                Assert.assertEquals((long)2L, (long)changes.length);
                Assert.assertTrue((boolean)(changes[0] instanceof DropColumnChange));
                Assert.assertEquals((Object)"NEWCOL", (Object)((DropColumnChange)changes[0]).getColumnName());
                Assert.assertTrue((boolean)(changes[1] instanceof DropColumnChange));
                Assert.assertEquals((Object)"NEWCOL2", (Object)((DropColumnChange)changes[1]).getColumnName());
            }
        });
    }

    @Test
    public void getConfirmationMessage() throws Exception {
        AddColumnChange refactoring = new AddColumnChange();
        refactoring.setTableName("TAB");
        ColumnConfig column = new ColumnConfig();
        column.setName("NEWCOL");
        column.setType("TYP");
        refactoring.addColumn(column);
        Assert.assertEquals((Object)"Columns NEWCOL(TYP) added to TAB", (Object)refactoring.getConfirmationMessage());
    }
}

