/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChangeTest;
import liquibase.change.core.AddDefaultValueChange;
import liquibase.database.Database;
import liquibase.database.core.MockDatabase;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddDefaultValueStatement;
import org.junit.Assert;
import org.junit.Test;

public class AddDefaultValueChangeTest
extends AbstractChangeTest {
    @Test
    public void generateStatement() throws Exception {
        AddDefaultValueChange change = new AddDefaultValueChange();
        change.setTableName("TABLE_NAME");
        change.setColumnName("COLUMN_NAME");
        change.setDefaultValue("New default value");
        change.setColumnDataType("VARCHAR(255)");
        SqlStatement[] statements = change.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)statements.length);
        AddDefaultValueStatement statement = (AddDefaultValueStatement)statements[0];
        Assert.assertEquals((Object)"TABLE_NAME", (Object)statement.getTableName());
        Assert.assertEquals((Object)"COLUMN_NAME", (Object)statement.getColumnName());
        Assert.assertEquals((Object)"New default value", (Object)statement.getDefaultValue());
        Assert.assertEquals((Object)"VARCHAR(255)", (Object)statement.getColumnDataType());
    }

    @Test
    public void generateStatements_intDefaultValue() throws Exception {
        AddDefaultValueChange change = new AddDefaultValueChange();
        change.setTableName("TABLE_NAME");
        change.setColumnName("COLUMN_NAME");
        change.setDefaultValueNumeric("42");
        SqlStatement[] statements = change.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)statements.length);
        AddDefaultValueStatement statement = (AddDefaultValueStatement)statements[0];
        Assert.assertEquals((Object)"TABLE_NAME", (Object)statement.getTableName());
        Assert.assertEquals((Object)"COLUMN_NAME", (Object)statement.getColumnName());
        Assert.assertTrue((boolean)(statement.getDefaultValue() instanceof Number));
        Assert.assertEquals((Object)"42", (Object)statement.getDefaultValue().toString());
    }

    @Test
    public void generateStatements_decimalDefaultValue() throws Exception {
        AddDefaultValueChange change = new AddDefaultValueChange();
        change.setTableName("TABLE_NAME");
        change.setColumnName("COLUMN_NAME");
        change.setDefaultValueNumeric("42.56");
        SqlStatement[] statements = change.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)statements.length);
        AddDefaultValueStatement statement = (AddDefaultValueStatement)statements[0];
        Assert.assertEquals((Object)"TABLE_NAME", (Object)statement.getTableName());
        Assert.assertEquals((Object)"COLUMN_NAME", (Object)statement.getColumnName());
        Assert.assertTrue((boolean)(statement.getDefaultValue() instanceof Number));
        Assert.assertEquals((Object)"42.56", (Object)statement.getDefaultValue().toString());
    }

    @Test
    public void generateStatements_computedNumeric() throws Exception {
        AddDefaultValueChange change = new AddDefaultValueChange();
        change.setTableName("TABLE_NAME");
        change.setColumnName("COLUMN_NAME");
        change.setDefaultValueNumeric("Math.random()");
        SqlStatement[] statements = change.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)statements.length);
        AddDefaultValueStatement statement = (AddDefaultValueStatement)statements[0];
        Assert.assertEquals((Object)"TABLE_NAME", (Object)statement.getTableName());
        Assert.assertEquals((Object)"COLUMN_NAME", (Object)statement.getColumnName());
        Assert.assertTrue((boolean)(statement.getDefaultValue() instanceof DatabaseFunction));
        Assert.assertEquals((Object)"Math.random()", (Object)statement.getDefaultValue().toString());
    }

    @Test
    public void generateStatements_computedDate() throws Exception {
        AddDefaultValueChange change = new AddDefaultValueChange();
        change.setTableName("TABLE_NAME");
        change.setColumnName("COLUMN_NAME");
        change.setDefaultValueDate("NOW()");
        SqlStatement[] statements = change.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)statements.length);
        AddDefaultValueStatement statement = (AddDefaultValueStatement)statements[0];
        Assert.assertEquals((Object)"TABLE_NAME", (Object)statement.getTableName());
        Assert.assertEquals((Object)"COLUMN_NAME", (Object)statement.getColumnName());
        Assert.assertTrue((boolean)(statement.getDefaultValue() instanceof DatabaseFunction));
        Assert.assertEquals((Object)"NOW()", (Object)statement.getDefaultValue().toString());
    }

    @Test
    public void generateStatements_booleanDefaultValue_true() throws Exception {
        AddDefaultValueChange change = new AddDefaultValueChange();
        change.setTableName("TABLE_NAME");
        change.setColumnName("COLUMN_NAME");
        change.setDefaultValueBoolean(Boolean.TRUE);
        SqlStatement[] statements = change.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)statements.length);
        AddDefaultValueStatement statement = (AddDefaultValueStatement)statements[0];
        Assert.assertEquals((Object)"TABLE_NAME", (Object)statement.getTableName());
        Assert.assertEquals((Object)"COLUMN_NAME", (Object)statement.getColumnName());
        Assert.assertTrue((boolean)(statement.getDefaultValue() instanceof Boolean));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)statement.getDefaultValue());
    }

    @Test
    public void generateStatements_booleanDefaultValue_false() throws Exception {
        AddDefaultValueChange change = new AddDefaultValueChange();
        change.setTableName("TABLE_NAME");
        change.setColumnName("COLUMN_NAME");
        change.setDefaultValueBoolean(Boolean.FALSE);
        SqlStatement[] statements = change.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)statements.length);
        AddDefaultValueStatement statement = (AddDefaultValueStatement)statements[0];
        Assert.assertEquals((Object)"TABLE_NAME", (Object)statement.getTableName());
        Assert.assertEquals((Object)"COLUMN_NAME", (Object)statement.getColumnName());
        Assert.assertTrue((boolean)(statement.getDefaultValue() instanceof Boolean));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)statement.getDefaultValue());
    }

    public void getRefactoringName() throws Exception {
        Assert.assertEquals((Object)"Add Default Value", (Object)new AddDefaultValueChange().getChangeMetaData().getDescription());
    }

    @Test
    public void getConfirmationMessage() throws Exception {
        AddDefaultValueChange change = new AddDefaultValueChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TABLE_NAME");
        change.setColumnName("COLUMN_NAME");
        Assert.assertEquals((Object)"Default value added to TABLE_NAME.COLUMN_NAME", (Object)change.getConfirmationMessage());
    }

    @Test
    public void getMD5Sum() throws Exception {
        AddDefaultValueChange change = new AddDefaultValueChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TABLE_NAME");
        change.setColumnName("COLUMN_NAME");
        change.setDefaultValue("DEF STRING");
        change.setDefaultValueNumeric("42");
        change.setDefaultValueBoolean(Boolean.valueOf(true));
        change.setDefaultValueDate("2007-01-02");
        String md5sum1 = change.generateCheckSum().toString();
        change.setSchemaName("SCHEMA_NAME2");
        String md5Sum2 = change.generateCheckSum().toString();
        Assert.assertFalse((boolean)md5sum1.equals(md5Sum2));
        change.setSchemaName("SCHEMA_NAME");
        String md5Sum3 = change.generateCheckSum().toString();
        Assert.assertTrue((boolean)md5sum1.equals(md5Sum3));
    }
}

