/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChangeTest;
import liquibase.change.core.AddForeignKeyConstraintChange;
import liquibase.database.Database;
import liquibase.database.core.MockDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddForeignKeyConstraintStatement;
import org.junit.Assert;
import org.junit.Test;

public class AddForeignKeyConstraintChangeTest
extends AbstractChangeTest {
    @Test
    public void generateStatement() throws Exception {
        AddForeignKeyConstraintChange change = new AddForeignKeyConstraintChange();
        change.setConstraintName("FK_NAME");
        change.setBaseTableSchemaName("BASE_SCHEMA_NAME");
        change.setBaseTableName("BASE_TABLE_NAME");
        change.setBaseColumnNames("BASE_COL_NAME");
        change.setReferencedTableSchemaName("REF_SCHEMA_NAME");
        change.setReferencedTableName("REF_TABLE_NAME");
        change.setReferencedColumnNames("REF_COL_NAME");
        change.setDeferrable(Boolean.valueOf(true));
        change.setDeleteCascade(Boolean.valueOf(true));
        change.setInitiallyDeferred(Boolean.valueOf(true));
        change.setReferencesUniqueColumn(Boolean.valueOf(false));
        SqlStatement[] statements = change.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)statements.length);
        AddForeignKeyConstraintStatement statement = (AddForeignKeyConstraintStatement)statements[0];
        Assert.assertEquals((Object)"FK_NAME", (Object)statement.getConstraintName());
        Assert.assertEquals((Object)"BASE_SCHEMA_NAME", (Object)statement.getBaseTableSchemaName());
        Assert.assertEquals((Object)"BASE_TABLE_NAME", (Object)statement.getBaseTableName());
        Assert.assertEquals((Object)"BASE_COL_NAME", (Object)statement.getBaseColumnNames());
        Assert.assertEquals((Object)"REF_SCHEMA_NAME", (Object)statement.getReferencedTableSchemaName());
        Assert.assertEquals((Object)"REF_TABLE_NAME", (Object)statement.getReferencedTableName());
        Assert.assertEquals((Object)"REF_COL_NAME", (Object)statement.getReferencedColumnNames());
        Assert.assertEquals((Object)true, (Object)statement.isDeferrable());
        Assert.assertEquals((Object)true, (Object)statement.isInitiallyDeferred());
        Assert.assertEquals((Object)false, (Object)statement.getReferencesUniqueColumn());
        Assert.assertEquals((Object)"CASCADE", (Object)statement.getOnDelete());
    }

    public void getRefactoringName() throws Exception {
        Assert.assertEquals((Object)"Add Foreign Key Constraint", (Object)new AddForeignKeyConstraintChange().getChangeMetaData().getDescription());
    }

    @Test
    public void getConfirmationMessage() throws Exception {
        AddForeignKeyConstraintChange change = new AddForeignKeyConstraintChange();
        change.setConstraintName("FK_NAME");
        change.setBaseTableSchemaName("SCHEMA_NAME");
        change.setBaseTableName("TABLE_NAME");
        change.setBaseColumnNames("COL_NAME");
        Assert.assertEquals((Object)"Foreign key contraint added to TABLE_NAME (COL_NAME)", (Object)change.getConfirmationMessage());
    }

    protected boolean changeIsUnsupported(Database database) {
        return database instanceof SQLiteDatabase;
    }
}

