/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChangeTest;
import liquibase.change.Change;
import liquibase.change.core.AddLookupTableChange;
import liquibase.database.Database;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.statement.SqlStatement;
import org.junit.Assert;

public class AddLookupTableChangeTest
extends AbstractChangeTest {
    public void getRefactoringName() throws Exception {
        Assert.assertEquals((Object)"Add Lookup Table", (Object)new AddLookupTableChange().getChangeMetaData().getDescription());
    }

    public void generateStatement() throws Exception {
        AddLookupTableChange change = new AddLookupTableChange();
        change.setExistingTableName("OLD_TABLE_NAME");
        change.setExistingColumnName("OLD_COLUMN_NAME");
        change.setExistingTableSchemaName("OLD_SCHEMA");
        change.setConstraintName("FK_NAME");
        change.setNewColumnDataType("TYPE(255)");
        change.setNewTableName("NEW_TABLE");
        change.setNewColumnName("NEW_COL");
        change.setNewTableSchemaName("NEW_SCHEM");
        this.testChangeOnAll((Change)change, new AbstractChangeTest.GenerateAllValidator(){

            public void validate(SqlStatement[] statements, Database database) {
            }
        });
    }

    public void getConfirmationMessage() throws Exception {
        AddLookupTableChange change = new AddLookupTableChange();
        change.setExistingTableName("OLD_TABLE_NAME");
        change.setExistingColumnName("OLD_COLUMN_NAME");
        Assert.assertEquals((Object)"Lookup table added for OLD_TABLE_NAME.OLD_COLUMN_NAME", (Object)change.getConfirmationMessage());
    }

    protected boolean changeIsUnsupported(Database database) {
        return database instanceof FirebirdDatabase || database instanceof SQLiteDatabase;
    }
}

