/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.math.BigInteger;
import liquibase.change.AbstractChangeTest;
import liquibase.change.core.AlterSequenceChange;
import liquibase.database.Database;
import liquibase.database.core.CacheDatabase;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MockDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.database.core.SybaseASADatabase;
import liquibase.database.core.SybaseDatabase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AlterSequenceStatement;
import org.junit.Assert;
import org.junit.Test;

public class AlterSequenceChangeTest
extends AbstractChangeTest {
    @Test
    public void getRefactoringName() throws Exception {
        Assert.assertEquals((Object)"Alter Sequence", (Object)new AlterSequenceChange().getChangeMetaData().getDescription());
    }

    @Test
    public void generateStatement() throws Exception {
        AlterSequenceChange refactoring = new AlterSequenceChange();
        refactoring.setSchemaName("SCHEMA_NAME");
        refactoring.setSequenceName("SEQ_NAME");
        refactoring.setMinValue(new BigInteger("100"));
        refactoring.setMaxValue(new BigInteger("1000"));
        refactoring.setIncrementBy(new BigInteger("50"));
        refactoring.setOrdered(Boolean.valueOf(true));
        SqlStatement[] sqlStatements = refactoring.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)sqlStatements.length);
        Assert.assertTrue((boolean)(sqlStatements[0] instanceof AlterSequenceStatement));
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)((AlterSequenceStatement)sqlStatements[0]).getSchemaName());
        Assert.assertEquals((Object)"SEQ_NAME", (Object)((AlterSequenceStatement)sqlStatements[0]).getSequenceName());
        Assert.assertEquals((Object)new BigInteger("100"), (Object)((AlterSequenceStatement)sqlStatements[0]).getMinValue());
        Assert.assertEquals((Object)new BigInteger("1000"), (Object)((AlterSequenceStatement)sqlStatements[0]).getMaxValue());
        Assert.assertEquals((Object)new BigInteger("50"), (Object)((AlterSequenceStatement)sqlStatements[0]).getIncrementBy());
        Assert.assertEquals((Object)true, (Object)((AlterSequenceStatement)sqlStatements[0]).getOrdered());
    }

    @Test
    public void getConfirmationMessage() throws Exception {
        AlterSequenceChange refactoring = new AlterSequenceChange();
        refactoring.setSequenceName("SEQ_NAME");
        Assert.assertEquals((Object)"Sequence SEQ_NAME altered", (Object)refactoring.getConfirmationMessage());
    }

    protected boolean changeIsUnsupported(Database database) {
        return database instanceof SQLiteDatabase || database instanceof SybaseASADatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase || database instanceof DerbyDatabase || database instanceof SybaseDatabase || database instanceof CacheDatabase;
    }
}

