/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.Change;
import liquibase.change.ChangeFactory;
import liquibase.change.core.AddAutoIncrementChange;
import liquibase.change.core.CreateTableChange;
import liquibase.change.core.DropTableChange;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChangeFactoryTest {
    @Before
    public void setup() {
        ChangeFactory.reset();
    }

    @Test
    public void getInstance() {
        Assert.assertNotNull((Object)ChangeFactory.getInstance());
        Assert.assertTrue((ChangeFactory.getInstance() == ChangeFactory.getInstance() ? 1 : 0) != 0);
    }

    @Test
    public void register() {
        ChangeFactory.getInstance().getRegistry().clear();
        Assert.assertEquals((long)0L, (long)ChangeFactory.getInstance().getRegistry().size());
        ChangeFactory.getInstance().register(CreateTableChange.class);
        Assert.assertEquals((long)1L, (long)ChangeFactory.getInstance().getRegistry().size());
    }

    @Test
    public void unregister_instance() {
        ChangeFactory factory = ChangeFactory.getInstance();
        factory.getRegistry().clear();
        Assert.assertEquals((long)0L, (long)factory.getRegistry().size());
        AddAutoIncrementChange change = new AddAutoIncrementChange();
        factory.register(CreateTableChange.class);
        factory.register(change.getClass());
        factory.register(DropTableChange.class);
        Assert.assertEquals((long)3L, (long)factory.getRegistry().size());
        factory.unregister(change.getChangeMetaData().getName());
        Assert.assertEquals((long)2L, (long)factory.getRegistry().size());
    }

    @Test
    public void unregister_doesNotExist() {
        ChangeFactory factory = ChangeFactory.getInstance();
        factory.getRegistry().clear();
        Assert.assertEquals((long)0L, (long)factory.getRegistry().size());
        factory.register(CreateTableChange.class);
        factory.register(AddAutoIncrementChange.class);
        factory.register(DropTableChange.class);
        Assert.assertEquals((long)3L, (long)factory.getRegistry().size());
        factory.unregister("doesNoExist");
        Assert.assertEquals((long)3L, (long)factory.getRegistry().size());
    }

    @Test
    public void create_exists() {
        Change change = ChangeFactory.getInstance().create("createTable");
        Assert.assertNotNull((Object)change);
        Assert.assertTrue((boolean)(change instanceof CreateTableChange));
    }

    @Test
    public void builtInGeneratorsAreFound() {
        Assert.assertTrue((ChangeFactory.getInstance().getRegistry().size() > 10 ? 1 : 0) != 0);
    }

    @Test
    public void create_notExists() {
        Change change = ChangeFactory.getInstance().create("badChangeName");
        Assert.assertNull((Object)change);
    }

    @Test
    public void reset() {
        ChangeFactory instance1 = ChangeFactory.getInstance();
        ChangeFactory.reset();
        Assert.assertFalse((instance1 == ChangeFactory.getInstance() ? 1 : 0) != 0);
    }
}

