/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChangeTest;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.core.CreateTableChange;
import liquibase.change.core.DropTableChange;
import liquibase.database.Database;
import liquibase.database.core.MockDatabase;
import liquibase.statement.ForeignKeyConstraint;
import liquibase.statement.SqlStatement;
import liquibase.statement.UniqueConstraint;
import liquibase.statement.core.CreateTableStatement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CreateTableChangeTest
extends AbstractChangeTest {
    private CreateTableChange change;

    @Before
    public void setUp() throws Exception {
        this.change = new CreateTableChange();
    }

    @Test
    public void getRefactoringName() throws Exception {
        Assert.assertEquals((Object)"Create Table", (Object)this.change.getChangeMetaData().getDescription());
    }

    @Test
    public void generateStatement() throws Exception {
        this.change.setTableName("TABLE_NAME");
        ColumnConfig column1 = new ColumnConfig();
        column1.setName("id");
        column1.setType("int");
        ConstraintsConfig column1constraints = new ConstraintsConfig();
        column1constraints.setPrimaryKey(Boolean.valueOf(true));
        column1constraints.setNullable(Boolean.valueOf(false));
        column1.setConstraints(column1constraints);
        this.change.addColumn(column1);
        ColumnConfig column2 = new ColumnConfig();
        column2.setName("name");
        column2.setType("varchar(255)");
        this.change.addColumn(column2);
        ColumnConfig column3 = new ColumnConfig();
        column3.setName("state_id");
        column3.setType("int");
        ConstraintsConfig column3constraints = new ConstraintsConfig();
        column3constraints.setNullable(Boolean.valueOf(false));
        column3constraints.setInitiallyDeferred(Boolean.valueOf(true));
        column3constraints.setDeferrable(Boolean.valueOf(true));
        column3constraints.setForeignKeyName("fk_tab_ref");
        column3constraints.setReferences("state(id)");
        column3.setConstraints(column3constraints);
        this.change.addColumn(column3);
        ColumnConfig column4 = new ColumnConfig();
        column4.setName("phone");
        column4.setType("varchar(255)");
        column4.setDefaultValue("NOPHONE");
        this.change.addColumn(column4);
        ColumnConfig column5 = new ColumnConfig();
        column5.setName("phone2");
        column5.setType("varchar(255)");
        ConstraintsConfig column5constraints = new ConstraintsConfig();
        column5constraints.setUnique(Boolean.valueOf(true));
        column5.setConstraints(column5constraints);
        this.change.addColumn(column5);
        SqlStatement[] statements = this.change.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)statements.length);
        Assert.assertTrue((boolean)(statements[0] instanceof CreateTableStatement));
        CreateTableStatement statement = (CreateTableStatement)statements[0];
        Assert.assertEquals((Object)"TABLE_NAME", (Object)statement.getTableName());
        Assert.assertTrue((boolean)statement.getColumns().contains("id"));
        Assert.assertTrue((boolean)statement.getColumns().contains("state_id"));
        Assert.assertTrue((boolean)statement.getColumns().contains("phone"));
        Assert.assertTrue((boolean)statement.getColumns().contains("phone2"));
        Assert.assertEquals((long)1L, (long)statement.getPrimaryKeyConstraint().getColumns().size());
        Assert.assertEquals((Object)"id", statement.getPrimaryKeyConstraint().getColumns().iterator().next());
        Assert.assertEquals((long)1L, (long)statement.getUniqueConstraints().size());
        UniqueConstraint uniqueConstraint = (UniqueConstraint)statement.getUniqueConstraints().iterator().next();
        Assert.assertEquals((long)1L, (long)uniqueConstraint.getColumns().size());
        Assert.assertEquals((Object)"phone2", uniqueConstraint.getColumns().iterator().next());
        Assert.assertEquals((long)2L, (long)statement.getNotNullColumns().size());
        Assert.assertEquals((long)1L, (long)statement.getForeignKeyConstraints().size());
        ForeignKeyConstraint keyConstraint = (ForeignKeyConstraint)statement.getForeignKeyConstraints().iterator().next();
        Assert.assertEquals((Object)"fk_tab_ref", (Object)keyConstraint.getForeignKeyName());
        Assert.assertEquals((Object)"state_id", (Object)keyConstraint.getColumn());
        Assert.assertEquals((Object)"state(id)", (Object)keyConstraint.getReferences());
        Assert.assertTrue((boolean)keyConstraint.isDeferrable());
        Assert.assertTrue((boolean)keyConstraint.isInitiallyDeferred());
    }

    @Test
    public void getConfirmationMessage() throws Exception {
        this.change.setTableName("TAB_NAME");
        Assert.assertEquals((Object)"Table TAB_NAME created", (Object)this.change.getConfirmationMessage());
    }

    @Test
    public void defaultValue_none() throws Exception {
        CreateTableChange change = new CreateTableChange();
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setName("id");
        columnConfig.setType("int");
        change.addColumn(columnConfig);
        CreateTableStatement statement = (CreateTableStatement)change.generateStatements((Database)new MockDatabase())[0];
        Assert.assertNull((Object)statement.getDefaultValue("id"));
    }

    @Test
    public void defaultValue_string() throws Exception {
        CreateTableChange change = new CreateTableChange();
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setName("id");
        columnConfig.setType("int");
        columnConfig.setDefaultValue("DEFAULTVALUE");
        change.addColumn(columnConfig);
        CreateTableStatement statement = (CreateTableStatement)change.generateStatements((Database)new MockDatabase())[0];
        Assert.assertEquals((Object)"DEFAULTVALUE", (Object)statement.getDefaultValue("id"));
    }

    @Test
    public void defaultValue_boolean() throws Exception {
        CreateTableChange change = new CreateTableChange();
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setName("id");
        columnConfig.setType("boolean");
        columnConfig.setDefaultValueBoolean(Boolean.TRUE);
        change.addColumn(columnConfig);
        CreateTableStatement statement = (CreateTableStatement)change.generateStatements((Database)new MockDatabase())[0];
        Assert.assertEquals((Object)true, (Object)statement.getDefaultValue("id"));
    }

    @Test
    public void defaultValue_numeric() throws Exception {
        CreateTableChange change = new CreateTableChange();
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setName("id");
        columnConfig.setType("int");
        columnConfig.setDefaultValueNumeric("42");
        change.addColumn(columnConfig);
        CreateTableStatement statement = (CreateTableStatement)change.generateStatements((Database)new MockDatabase())[0];
        Assert.assertEquals((Object)42L, (Object)statement.getDefaultValue("id"));
    }

    @Test
    public void defaultValue_date() throws Exception {
        CreateTableChange change = new CreateTableChange();
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setName("id");
        columnConfig.setType("date");
        columnConfig.setDefaultValueDate("2007-01-02");
        change.addColumn(columnConfig);
        CreateTableStatement statement = (CreateTableStatement)change.generateStatements((Database)new MockDatabase())[0];
        Assert.assertEquals((Object)columnConfig.getDefaultValueDate(), (Object)statement.getDefaultValue("id"));
    }

    @Test
    public void createInverse() {
        CreateTableChange change = new CreateTableChange();
        change.setTableName("TestTable");
        Change[] inverses = change.createInverses();
        Assert.assertEquals((long)1L, (long)inverses.length);
        Assert.assertTrue((boolean)(inverses[0] instanceof DropTableChange));
        Assert.assertEquals((Object)"TestTable", (Object)((DropTableChange)inverses[0]).getTableName());
    }

    @Test
    public void tableSpace_none() throws Exception {
        CreateTableChange change = new CreateTableChange();
        CreateTableStatement statement = (CreateTableStatement)change.generateStatements((Database)new MockDatabase())[0];
        Assert.assertNull((Object)statement.getTablespace());
    }

    @Test
    public void tableSpace_set() throws Exception {
        CreateTableChange change = new CreateTableChange();
        change.setTablespace("TESTTABLESPACE");
        CreateTableStatement statement = (CreateTableStatement)change.generateStatements((Database)new MockDatabase())[0];
        Assert.assertEquals((Object)"TESTTABLESPACE", (Object)statement.getTablespace());
    }

    @Test
    public void foreignKey_deferrable() throws Exception {
        CreateTableChange change = new CreateTableChange();
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setName("id");
        columnConfig.setType("int");
        ConstraintsConfig constraints = new ConstraintsConfig();
        constraints.setForeignKeyName("fk_test");
        constraints.setReferences("test(id)");
        constraints.setDeferrable(Boolean.valueOf(true));
        constraints.setInitiallyDeferred(Boolean.valueOf(true));
        columnConfig.setConstraints(constraints);
        change.addColumn(columnConfig);
        CreateTableStatement statement = (CreateTableStatement)change.generateStatements((Database)new MockDatabase())[0];
        ForeignKeyConstraint keyConstraint = (ForeignKeyConstraint)statement.getForeignKeyConstraints().iterator().next();
        Assert.assertTrue((boolean)keyConstraint.isDeferrable());
        Assert.assertTrue((boolean)keyConstraint.isInitiallyDeferred());
    }

    @Test
    public void foreignKey_notDeferrable() throws Exception {
        CreateTableChange change = new CreateTableChange();
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setName("id");
        columnConfig.setType("int");
        ConstraintsConfig constraints = new ConstraintsConfig();
        constraints.setForeignKeyName("fk_test");
        constraints.setReferences("test(id)");
        constraints.setDeferrable(Boolean.valueOf(false));
        constraints.setInitiallyDeferred(Boolean.valueOf(false));
        columnConfig.setConstraints(constraints);
        change.addColumn(columnConfig);
        CreateTableStatement statement = (CreateTableStatement)change.generateStatements((Database)new MockDatabase())[0];
        ForeignKeyConstraint keyConstraint = (ForeignKeyConstraint)statement.getForeignKeyConstraints().iterator().next();
        Assert.assertFalse((boolean)keyConstraint.isDeferrable());
        Assert.assertFalse((boolean)keyConstraint.isInitiallyDeferred());
    }

    @Test
    public void foreignKey_defaultDeferrable() throws Exception {
        CreateTableChange change = new CreateTableChange();
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setName("id");
        columnConfig.setType("int");
        ConstraintsConfig constraints = new ConstraintsConfig();
        constraints.setReferences("test(id)");
        constraints.setForeignKeyName("fk_test");
        columnConfig.setConstraints(constraints);
        change.addColumn(columnConfig);
        CreateTableStatement statement = (CreateTableStatement)change.generateStatements((Database)new MockDatabase())[0];
        ForeignKeyConstraint keyConstraint = (ForeignKeyConstraint)statement.getForeignKeyConstraints().iterator().next();
        Assert.assertFalse((boolean)keyConstraint.isDeferrable());
        Assert.assertFalse((boolean)keyConstraint.isInitiallyDeferred());
    }
}

