/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChangeTest;
import liquibase.change.core.DropColumnChange;
import liquibase.database.Database;
import liquibase.database.core.MockDatabase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DropColumnStatement;
import org.junit.Assert;
import org.junit.Test;

public class DropColumnChangeTest
extends AbstractChangeTest {
    @Test
    public void getRefactoringName() throws Exception {
        Assert.assertEquals((Object)"Drop Column", (Object)new DropColumnChange().getChangeMetaData().getDescription());
    }

    @Test
    public void generateStatement() throws Exception {
        DropColumnChange change = new DropColumnChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TABLE_NAME");
        change.setColumnName("COL_HERE");
        SqlStatement[] sqlStatements = change.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)sqlStatements.length);
        Assert.assertTrue((boolean)(sqlStatements[0] instanceof DropColumnStatement));
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)((DropColumnStatement)sqlStatements[0]).getSchemaName());
        Assert.assertEquals((Object)"TABLE_NAME", (Object)((DropColumnStatement)sqlStatements[0]).getTableName());
        Assert.assertEquals((Object)"COL_HERE", (Object)((DropColumnStatement)sqlStatements[0]).getColumnName());
    }

    @Test
    public void getConfirmationMessage() throws Exception {
        DropColumnChange change = new DropColumnChange();
        change.setTableName("TABLE_NAME");
        change.setColumnName("COL_HERE");
        Assert.assertEquals((Object)"Column TABLE_NAME.COL_HERE dropped", (Object)change.getConfirmationMessage());
    }
}

