/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChangeTest;
import liquibase.change.core.DropDefaultValueChange;
import liquibase.database.Database;
import liquibase.database.core.MockDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DropDefaultValueStatement;
import org.junit.Assert;
import org.junit.Test;

public class DropDefaultValueChangeTest
extends AbstractChangeTest {
    @Test
    public void getRefactoringName() throws Exception {
        Assert.assertEquals((Object)"Drop Default Value", (Object)new DropDefaultValueChange().getChangeMetaData().getDescription());
    }

    @Test
    public void generateStatement() throws Exception {
        DropDefaultValueChange change = new DropDefaultValueChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TABLE_NAME");
        change.setColumnName("COL_HERE");
        SqlStatement[] sqlStatements = change.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)sqlStatements.length);
        Assert.assertTrue((boolean)(sqlStatements[0] instanceof DropDefaultValueStatement));
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)((DropDefaultValueStatement)sqlStatements[0]).getSchemaName());
        Assert.assertEquals((Object)"TABLE_NAME", (Object)((DropDefaultValueStatement)sqlStatements[0]).getTableName());
        Assert.assertEquals((Object)"COL_HERE", (Object)((DropDefaultValueStatement)sqlStatements[0]).getColumnName());
    }

    @Test
    public void getConfirmationMessage() throws Exception {
        DropDefaultValueChange change = new DropDefaultValueChange();
        change.setTableName("TABLE_NAME");
        change.setColumnName("COL_HERE");
        Assert.assertEquals((Object)"Default value dropped from TABLE_NAME.COL_HERE", (Object)change.getConfirmationMessage());
    }

    protected boolean changeIsUnsupported(Database database) {
        return database instanceof SQLiteDatabase;
    }
}

