/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChangeTest;
import liquibase.change.core.DropIndexChange;
import liquibase.database.Database;
import liquibase.database.core.MockDatabase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DropIndexStatement;
import org.junit.Assert;
import org.junit.Test;

public class DropIndexChangeTest
extends AbstractChangeTest {
    @Test
    public void getRefactoringName() throws Exception {
        Assert.assertEquals((Object)"Drop Index", (Object)new DropIndexChange().getChangeMetaData().getDescription());
    }

    @Test
    public void generateStatement() throws Exception {
        DropIndexChange refactoring = new DropIndexChange();
        refactoring.setIndexName("IDX_NAME");
        refactoring.setTableName("TABLE_NAME");
        refactoring.setSchemaName("SCHEMA_NAME");
        SqlStatement[] sqlStatements = refactoring.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)sqlStatements.length);
        Assert.assertTrue((boolean)(sqlStatements[0] instanceof DropIndexStatement));
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)((DropIndexStatement)sqlStatements[0]).getTableSchemaName());
        Assert.assertEquals((Object)"TABLE_NAME", (Object)((DropIndexStatement)sqlStatements[0]).getTableName());
        Assert.assertEquals((Object)"IDX_NAME", (Object)((DropIndexStatement)sqlStatements[0]).getIndexName());
    }

    @Test
    public void getConfirmationMessage() throws Exception {
        DropIndexChange refactoring = new DropIndexChange();
        refactoring.setIndexName("IDX_NAME");
        refactoring.setTableName("TABLE_NAME");
        Assert.assertEquals((Object)"Index IDX_NAME dropped from table TABLE_NAME", (Object)refactoring.getConfirmationMessage());
    }
}

