/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChangeTest;
import liquibase.change.core.DropNotNullConstraintChange;
import liquibase.database.Database;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.MockDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.SetNullableStatement;
import org.junit.Assert;
import org.junit.Test;

public class DropNotNullConstraintChangeTest
extends AbstractChangeTest {
    @Test
    public void getRefactoringName() throws Exception {
        Assert.assertEquals((Object)"Drop Not-Null Constraint", (Object)new DropNotNullConstraintChange().getChangeMetaData().getDescription());
    }

    @Test
    public void generateStatement() throws Exception {
        DropNotNullConstraintChange change = new DropNotNullConstraintChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TABLE_NAME");
        change.setColumnName("COL_HERE");
        change.setColumnDataType("varchar(200)");
        SqlStatement[] sqlStatements = change.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)sqlStatements.length);
        Assert.assertTrue((boolean)(sqlStatements[0] instanceof SetNullableStatement));
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)((SetNullableStatement)sqlStatements[0]).getSchemaName());
        Assert.assertEquals((Object)"TABLE_NAME", (Object)((SetNullableStatement)sqlStatements[0]).getTableName());
        Assert.assertEquals((Object)"COL_HERE", (Object)((SetNullableStatement)sqlStatements[0]).getColumnName());
        Assert.assertEquals((Object)"varchar(200)", (Object)((SetNullableStatement)sqlStatements[0]).getColumnDataType());
        Assert.assertTrue((boolean)((SetNullableStatement)sqlStatements[0]).isNullable());
    }

    @Test
    public void getConfirmationMessage() throws Exception {
        DropNotNullConstraintChange change = new DropNotNullConstraintChange();
        change.setTableName("TABLE_NAME");
        change.setColumnName("COL_HERE");
        Assert.assertEquals((Object)"Null constraint dropped from TABLE_NAME.COL_HERE", (Object)change.getConfirmationMessage());
    }

    protected boolean changeIsUnsupported(Database database) {
        return database instanceof FirebirdDatabase || database instanceof SQLiteDatabase;
    }
}

