/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChangeTest;
import liquibase.change.core.DropPrimaryKeyChange;
import liquibase.database.Database;
import liquibase.database.core.MockDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DropPrimaryKeyStatement;
import org.junit.Assert;
import org.junit.Test;

public class DropPrimaryKeyChangeTest
extends AbstractChangeTest {
    @Test
    public void getRefactoringName() throws Exception {
        Assert.assertEquals((Object)"Drop Primary Key", (Object)new DropPrimaryKeyChange().getChangeMetaData().getDescription());
    }

    @Test
    public void generateStatement() throws Exception {
        DropPrimaryKeyChange change = new DropPrimaryKeyChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TABLE_NAME");
        change.setConstraintName("PK_NAME");
        SqlStatement[] sqlStatements = change.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)sqlStatements.length);
        Assert.assertTrue((boolean)(sqlStatements[0] instanceof DropPrimaryKeyStatement));
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)((DropPrimaryKeyStatement)sqlStatements[0]).getSchemaName());
        Assert.assertEquals((Object)"TABLE_NAME", (Object)((DropPrimaryKeyStatement)sqlStatements[0]).getTableName());
        Assert.assertEquals((Object)"PK_NAME", (Object)((DropPrimaryKeyStatement)sqlStatements[0]).getConstraintName());
    }

    @Test
    public void getConfirmationMessage() throws Exception {
        DropPrimaryKeyChange change = new DropPrimaryKeyChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TABLE_NAME");
        change.setConstraintName("PK_NAME");
        Assert.assertEquals((Object)"Primary key dropped from TABLE_NAME", (Object)change.getConfirmationMessage());
    }

    protected boolean changeIsUnsupported(Database database) {
        return database instanceof SQLiteDatabase;
    }
}

