/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChangeTest;
import liquibase.change.core.DropTableChange;
import liquibase.database.Database;
import liquibase.database.core.MockDatabase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DropTableStatement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DropTableChangeTest
extends AbstractChangeTest {
    private DropTableChange change;

    @Before
    public void setUp() throws Exception {
        this.change = new DropTableChange();
        this.change.setSchemaName("SCHEMA_NAME");
        this.change.setTableName("TAB_NAME");
        this.change.setCascadeConstraints(Boolean.valueOf(true));
    }

    @Test
    public void getRefactoringName() throws Exception {
        Assert.assertEquals((Object)"Drop Table", (Object)this.change.getChangeMetaData().getDescription());
    }

    @Test
    public void generateStatement() throws Exception {
        SqlStatement[] sqlStatements = this.change.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)sqlStatements.length);
        Assert.assertTrue((boolean)(sqlStatements[0] instanceof DropTableStatement));
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)((DropTableStatement)sqlStatements[0]).getSchemaName());
        Assert.assertEquals((Object)"TAB_NAME", (Object)((DropTableStatement)sqlStatements[0]).getTableName());
        Assert.assertTrue((boolean)((DropTableStatement)sqlStatements[0]).isCascadeConstraints());
    }

    @Test
    public void generateStatement_nullCascadeConstraints() throws Exception {
        this.change.setCascadeConstraints(null);
        SqlStatement[] sqlStatements = this.change.generateStatements((Database)new MockDatabase());
        Assert.assertFalse((boolean)((DropTableStatement)sqlStatements[0]).isCascadeConstraints());
    }

    @Test
    public void getConfirmationMessage() throws Exception {
        Assert.assertEquals((Object)"Table TAB_NAME dropped", (Object)this.change.getConfirmationMessage());
    }
}

