/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChangeTest;
import liquibase.change.core.DropUniqueConstraintChange;
import liquibase.database.Database;
import liquibase.database.core.MockDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DropUniqueConstraintStatement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DropUniqueConstraintChangeTest
extends AbstractChangeTest {
    private DropUniqueConstraintChange change;

    @Before
    public void setUp() throws Exception {
        this.change = new DropUniqueConstraintChange();
        this.change.setSchemaName("SCHEMA_NAME");
        this.change.setTableName("TAB_NAME");
        this.change.setConstraintName("UQ_CONSTRAINT");
    }

    @Test
    public void getRefactoringName() throws Exception {
        Assert.assertEquals((Object)"Drop Unique Constraint", (Object)this.change.getChangeMetaData().getDescription());
    }

    @Test
    public void generateStatement() throws Exception {
        SqlStatement[] sqlStatements = this.change.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)sqlStatements.length);
        Assert.assertTrue((boolean)(sqlStatements[0] instanceof DropUniqueConstraintStatement));
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)((DropUniqueConstraintStatement)sqlStatements[0]).getSchemaName());
        Assert.assertEquals((Object)"TAB_NAME", (Object)((DropUniqueConstraintStatement)sqlStatements[0]).getTableName());
        Assert.assertEquals((Object)"UQ_CONSTRAINT", (Object)((DropUniqueConstraintStatement)sqlStatements[0]).getConstraintName());
    }

    @Test
    public void getConfirmationMessage() throws Exception {
        Assert.assertEquals((Object)"Unique constraint UQ_CONSTRAINT dropped from TAB_NAME", (Object)this.change.getConfirmationMessage());
    }

    protected boolean changeIsUnsupported(Database database) {
        return database instanceof SQLiteDatabase;
    }
}

