/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChangeTest;
import liquibase.change.ColumnConfig;
import liquibase.change.core.InsertDataChange;
import liquibase.database.Database;
import liquibase.database.core.MockDatabase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertStatement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InsertDataChangeTest
extends AbstractChangeTest {
    InsertDataChange refactoring;

    @Before
    public void setUp() throws Exception {
        this.refactoring = new InsertDataChange();
        this.refactoring.setTableName("TABLE_NAME");
        ColumnConfig col1 = new ColumnConfig();
        col1.setName("id");
        col1.setValueNumeric("123");
        ColumnConfig col2 = new ColumnConfig();
        col2.setName("name");
        col2.setValue("Andrew");
        ColumnConfig col3 = new ColumnConfig();
        col3.setName("age");
        col3.setValueNumeric("21");
        ColumnConfig col4 = new ColumnConfig();
        col4.setName("height");
        col4.setValueNumeric("1.78");
        this.refactoring.addColumn(col1);
        this.refactoring.addColumn(col2);
        this.refactoring.addColumn(col3);
        this.refactoring.addColumn(col4);
    }

    @Test
    public void getRefactoringName() throws Exception {
        Assert.assertEquals((Object)"Insert Row", (Object)this.refactoring.getChangeMetaData().getDescription());
    }

    @Test
    public void generateStatement() throws Exception {
        SqlStatement[] sqlStatements = this.refactoring.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)sqlStatements.length);
        Assert.assertTrue((boolean)(sqlStatements[0] instanceof InsertStatement));
        Assert.assertEquals((Object)"123", (Object)((InsertStatement)sqlStatements[0]).getColumnValue("id").toString());
        Assert.assertEquals((Object)"Andrew", (Object)((InsertStatement)sqlStatements[0]).getColumnValue("name").toString());
        Assert.assertEquals((Object)"21", (Object)((InsertStatement)sqlStatements[0]).getColumnValue("age").toString());
        Assert.assertEquals((Object)"1.78", (Object)((InsertStatement)sqlStatements[0]).getColumnValue("height").toString());
    }

    @Test
    public void getConfirmationMessage() throws Exception {
        Assert.assertEquals((Object)"New row inserted into TABLE_NAME", (Object)this.refactoring.getConfirmationMessage());
    }
}

