/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChangeTest;
import liquibase.change.core.LoadDataChange;
import liquibase.change.core.LoadDataColumnConfig;
import liquibase.database.Database;
import liquibase.database.core.MockDatabase;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertStatement;
import org.junit.Assert;
import org.junit.Test;

public class LoadDataChangeTest
extends AbstractChangeTest {
    @Test
    public void getRefactoringName() throws Exception {
        Assert.assertEquals((Object)"Load Data", (Object)new LoadDataChange().getChangeMetaData().getDescription());
    }

    @Test
    public void loadDataEmpty() throws Exception {
        LoadDataChange refactoring = new LoadDataChange();
        refactoring.setSchemaName("SCHEMA_NAME");
        refactoring.setTableName("TABLE_NAME");
        refactoring.setFile("liquibase/change/core/empty.data.csv");
        refactoring.setSeparator(",");
        refactoring.setResourceAccessor((ResourceAccessor)new ClassLoaderResourceAccessor());
        SqlStatement[] sqlStatements = refactoring.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)0L, (long)sqlStatements.length);
    }

    @Test
    public void loadDataTsv() throws Exception {
        LoadDataChange refactoring = new LoadDataChange();
        refactoring.setSchemaName("SCHEMA_NAME");
        refactoring.setTableName("TABLE_NAME");
        refactoring.setFile("liquibase/change/core/sample.data1.tsv");
        refactoring.setSeparator("\t");
        refactoring.setResourceAccessor((ResourceAccessor)new ClassLoaderResourceAccessor());
        SqlStatement[] sqlStatements = refactoring.generateStatements((Database)new MockDatabase());
        this.stdAssertOfLoaded(sqlStatements);
    }

    @Test
    public void loadDataCsvQuotChar() throws Exception {
        LoadDataChange refactoring = new LoadDataChange();
        refactoring.setSchemaName("SCHEMA_NAME");
        refactoring.setTableName("TABLE_NAME");
        refactoring.setFile("liquibase/change/core/sample.quotchar.tsv");
        refactoring.setSeparator("\t");
        refactoring.setQuotchar("'");
        refactoring.setResourceAccessor((ResourceAccessor)new ClassLoaderResourceAccessor());
        SqlStatement[] sqlStatements = refactoring.generateStatements((Database)new MockDatabase());
        this.stdAssertOfLoaded(sqlStatements);
    }

    private void stdAssertOfLoaded(SqlStatement[] sqlStatements) {
        Assert.assertEquals((long)2L, (long)sqlStatements.length);
        Assert.assertTrue((boolean)(sqlStatements[0] instanceof InsertStatement));
        Assert.assertTrue((boolean)(sqlStatements[1] instanceof InsertStatement));
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)((InsertStatement)sqlStatements[0]).getSchemaName());
        Assert.assertEquals((Object)"TABLE_NAME", (Object)((InsertStatement)sqlStatements[0]).getTableName());
        Assert.assertEquals((Object)"Bob Johnson", (Object)((InsertStatement)sqlStatements[0]).getColumnValue("name"));
        Assert.assertEquals((Object)"bjohnson", (Object)((InsertStatement)sqlStatements[0]).getColumnValue("username"));
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)((InsertStatement)sqlStatements[1]).getSchemaName());
        Assert.assertEquals((Object)"TABLE_NAME", (Object)((InsertStatement)sqlStatements[1]).getTableName());
        Assert.assertEquals((Object)"John Doe", (Object)((InsertStatement)sqlStatements[1]).getColumnValue("name"));
        Assert.assertEquals((Object)"jdoe", (Object)((InsertStatement)sqlStatements[1]).getColumnValue("username"));
    }

    @Test
    public void generateStatement() throws Exception {
        LoadDataChange refactoring = new LoadDataChange();
        refactoring.setSchemaName("SCHEMA_NAME");
        refactoring.setTableName("TABLE_NAME");
        refactoring.setFile("liquibase/change/core/sample.data1.csv");
        refactoring.setResourceAccessor((ResourceAccessor)new ClassLoaderResourceAccessor());
        SqlStatement[] sqlStatements = refactoring.generateStatements((Database)new MockDatabase());
        this.stdAssertOfLoaded(sqlStatements);
    }

    @Test
    public void generateStatement_excel() throws Exception {
        LoadDataChange refactoring = new LoadDataChange();
        refactoring.setSchemaName("SCHEMA_NAME");
        refactoring.setTableName("TABLE_NAME");
        refactoring.setFile("liquibase/change/core/sample.data1-excel.csv");
        refactoring.setResourceAccessor((ResourceAccessor)new ClassLoaderResourceAccessor());
        LoadDataColumnConfig ageConfig = new LoadDataColumnConfig();
        ageConfig.setHeader("age");
        ageConfig.setType("NUMERIC");
        refactoring.addColumn(ageConfig);
        LoadDataColumnConfig activeConfig = new LoadDataColumnConfig();
        activeConfig.setHeader("active");
        activeConfig.setType("BOOLEAN");
        refactoring.addColumn(activeConfig);
        SqlStatement[] sqlStatements = refactoring.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)2L, (long)sqlStatements.length);
        Assert.assertTrue((boolean)(sqlStatements[0] instanceof InsertStatement));
        Assert.assertTrue((boolean)(sqlStatements[1] instanceof InsertStatement));
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)((InsertStatement)sqlStatements[0]).getSchemaName());
        Assert.assertEquals((Object)"TABLE_NAME", (Object)((InsertStatement)sqlStatements[0]).getTableName());
        Assert.assertEquals((Object)"Bob Johnson", (Object)((InsertStatement)sqlStatements[0]).getColumnValue("name"));
        Assert.assertEquals((Object)"bjohnson", (Object)((InsertStatement)sqlStatements[0]).getColumnValue("username"));
        Assert.assertEquals((Object)"15", (Object)((InsertStatement)sqlStatements[0]).getColumnValue("age").toString());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)((InsertStatement)sqlStatements[0]).getColumnValue("active"));
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)((InsertStatement)sqlStatements[1]).getSchemaName());
        Assert.assertEquals((Object)"TABLE_NAME", (Object)((InsertStatement)sqlStatements[1]).getTableName());
        Assert.assertEquals((Object)"John Doe", (Object)((InsertStatement)sqlStatements[1]).getColumnValue("name"));
        Assert.assertEquals((Object)"jdoe", (Object)((InsertStatement)sqlStatements[1]).getColumnValue("username"));
        Assert.assertEquals((Object)"21", (Object)((InsertStatement)sqlStatements[1]).getColumnValue("age").toString());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)((InsertStatement)sqlStatements[1]).getColumnValue("active"));
    }

    @Test
    public void getConfirmationMessage() throws Exception {
        LoadDataChange refactoring = new LoadDataChange();
        refactoring.setTableName("TABLE_NAME");
        refactoring.setFile("FILE_NAME");
        Assert.assertEquals((Object)"Data loaded from FILE_NAME into TABLE_NAME", (Object)refactoring.getConfirmationMessage());
    }

    @Test
    public void generateCheckSum() throws Exception {
        LoadDataChange refactoring = new LoadDataChange();
        refactoring.setSchemaName("SCHEMA_NAME");
        refactoring.setTableName("TABLE_NAME");
        refactoring.setFile("liquibase/change/core/sample.data1.csv");
        refactoring.setResourceAccessor((ResourceAccessor)new ClassLoaderResourceAccessor());
        String md5sum1 = refactoring.generateCheckSum().toString();
        refactoring.setFile("liquibase/change/core/sample.data2.csv");
        String md5sum2 = refactoring.generateCheckSum().toString();
        Assert.assertTrue((!md5sum1.equals(md5sum2) ? 1 : 0) != 0);
        Assert.assertEquals((Object)md5sum2, (Object)refactoring.generateCheckSum().toString());
    }

    public void isSupported() throws Exception {
    }

    public void validate() throws Exception {
    }
}

