/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import liquibase.change.AbstractChangeTest;
import liquibase.change.core.LoadUpdateDataChange;
import liquibase.database.Database;
import liquibase.database.core.MockDatabase;
import liquibase.exception.LiquibaseException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DeleteStatement;
import liquibase.statement.core.InsertOrUpdateStatement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LoadUpdateDataChangeTest
extends AbstractChangeTest {
    LoadUpdateDataChange refactoring;

    @Before
    public void setUp() throws Exception {
        this.refactoring = new LoadUpdateDataChange();
    }

    public void getRefactoringName() throws Exception {
        Assert.assertEquals((Object)"Smart Load Data", (Object)this.refactoring.getChangeMetaData().getDescription());
    }

    public void generateStatement() throws Exception {
        MockDatabase database = new MockDatabase();
        LoadUpdateDataChange change = new LoadUpdateDataChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TABLE_NAME");
        change.setPrimaryKey("name");
        change.setFile("liquibase/change/core/sample.data1.csv");
        change.setResourceAccessor((ResourceAccessor)new ClassLoaderResourceAccessor());
        SqlStatement[] statements = change.generateStatements((Database)database);
        SqlStatement[] sqlStatements = change.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)2L, (long)sqlStatements.length);
        Assert.assertTrue((boolean)(sqlStatements[0] instanceof InsertOrUpdateStatement));
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)((InsertOrUpdateStatement)sqlStatements[0]).getSchemaName());
        Assert.assertEquals((Object)"TABLE_NAME", (Object)((InsertOrUpdateStatement)sqlStatements[0]).getTableName());
        Assert.assertEquals((Object)"name", (Object)((InsertOrUpdateStatement)sqlStatements[0]).getPrimaryKey());
    }

    public void getConfirmationMessage() throws Exception {
        LoadUpdateDataChange refactoring = new LoadUpdateDataChange();
        refactoring.setTableName("TABLE_NAME");
        refactoring.setFile("FILE_NAME");
        Assert.assertEquals((Object)"Data loaded from FILE_NAME into TABLE_NAME", (Object)refactoring.getConfirmationMessage());
    }

    @Test
    public void getStatements() throws Exception {
        MockDatabase database = new MockDatabase();
        LoadUpdateDataChange change = new LoadUpdateDataChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TABLE_NAME");
        change.setFile("liquibase/change/core/sample.data1.csv");
        change.setResourceAccessor((ResourceAccessor)new ClassLoaderResourceAccessor());
        SqlStatement[] statements = change.generateStatements((Database)database);
        Assert.assertNotNull((Object)statements);
        Assert.assertEquals(InsertOrUpdateStatement.class, statements[0].getClass());
    }

    @Test
    public void generateSql() {
        MockDatabase database = new MockDatabase();
        LoadUpdateDataChange change = new LoadUpdateDataChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TABLE_NAME");
        change.setFile("liquibase/change/core/sample.data1.csv");
        change.setResourceAccessor((ResourceAccessor)new ClassLoaderResourceAccessor());
        SqlStatement[] statements = change.generateStatements((Database)database);
        Assert.assertNotNull((Object)statements);
        Assert.assertEquals(InsertOrUpdateStatement.class, statements[0].getClass());
    }

    @Test
    public void primaryKey() throws LiquibaseException {
        LoadUpdateDataChange change = new LoadUpdateDataChange();
        String primaryKey = "myPrimaryKey";
        change.setPrimaryKey(primaryKey);
        Assert.assertEquals((Object)primaryKey, (Object)change.getPrimaryKey());
    }

    @Test
    public void primaryKeyNullThrowsException() {
        LoadUpdateDataChange change = new LoadUpdateDataChange();
        try {
            change.setPrimaryKey(null);
            junit.framework.Assert.fail((String)"setPrimaryKey did not throw InvalidArgumentException as expected.");
        }
        catch (LiquibaseException liquibaseException) {
            // empty catch block
        }
    }

    @Test
    public void getWhereClause() throws LiquibaseException {
        MockDatabase database = new MockDatabase();
        LoadUpdateDataChange change = new LoadUpdateDataChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TABLE_NAME");
        change.setFile("liquibase/change/core/sample.data1.csv");
        change.setResourceAccessor((ResourceAccessor)new ClassLoaderResourceAccessor());
        change.setPrimaryKey("name");
        SqlStatement[] statements = change.generateStatements((Database)database);
        Object[] args = new Object[]{statements[0], database};
        String result = (String)LoadUpdateDataChangeTest.invokePrivateMethod(change, "getWhereClause", args);
        Assert.assertEquals((Object)"name = 'Bob Johnson'", (Object)result.trim());
        args = new Object[]{statements[1], database};
        result = (String)LoadUpdateDataChangeTest.invokePrivateMethod(change, "getWhereClause", args);
        Assert.assertEquals((Object)"name = 'John Doe'", (Object)result.trim());
    }

    @Test
    public void generateRollbacksForData1CSV() throws UnsupportedChangeException, RollbackImpossibleException, LiquibaseException {
        MockDatabase database = new MockDatabase();
        LoadUpdateDataChange change = new LoadUpdateDataChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TABLE_NAME");
        change.setFile("liquibase/change/core/sample.data1.csv");
        change.setResourceAccessor((ResourceAccessor)new ClassLoaderResourceAccessor());
        change.setPrimaryKey("name");
        SqlStatement[] statements = change.generateRollbackStatements((Database)database);
        Assert.assertNotNull((Object)statements);
        Assert.assertEquals(DeleteStatement.class, statements[0].getClass());
        DeleteStatement delete = (DeleteStatement)statements[0];
        Assert.assertEquals((Object)"name = 'Bob Johnson'", (Object)delete.getWhereClause().trim());
        delete = (DeleteStatement)statements[1];
        Assert.assertEquals((Object)"name = 'John Doe'", (Object)delete.getWhereClause().trim());
    }

    public void generateCheckSum() throws Exception {
        LoadUpdateDataChange refactoring = new LoadUpdateDataChange();
        refactoring.setSchemaName("SCHEMA_NAME");
        refactoring.setTableName("TABLE_NAME");
        refactoring.setFile("liquibase/change/core/sample.data1.csv");
        refactoring.setResourceAccessor((ResourceAccessor)new ClassLoaderResourceAccessor());
        String md5sum1 = refactoring.generateCheckSum().toString();
        refactoring.setFile("liquibase/change/core/sample.data2.csv");
        String md5sum2 = refactoring.generateCheckSum().toString();
        Assert.assertTrue((!md5sum1.equals(md5sum2) ? 1 : 0) != 0);
        Assert.assertEquals((Object)md5sum2, (Object)refactoring.generateCheckSum().toString());
    }

    public void isSupported() throws Exception {
    }

    public void validate() throws Exception {
    }

    public static Object invokePrivateMethod(Object o, String methodName, Object[] params) {
        junit.framework.Assert.assertNotNull((Object)o);
        junit.framework.Assert.assertNotNull((Object)methodName);
        junit.framework.Assert.assertNotNull((Object)params);
        Method[] methods = o.getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            try {
                methods[i].setAccessible(true);
                return methods[i].invoke(o, params);
            }
            catch (IllegalAccessException ex) {
                junit.framework.Assert.fail((String)("IllegalAccessException accessing " + methodName));
                continue;
            }
            catch (InvocationTargetException ite) {
                junit.framework.Assert.fail((String)("InvocationTargetException accessing " + methodName));
            }
        }
        junit.framework.Assert.fail((String)("Method '" + methodName + "' not found"));
        return null;
    }
}

