/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChangeTest;
import liquibase.change.core.RenameColumnChange;
import liquibase.database.Database;
import liquibase.database.core.CacheDatabase;
import liquibase.database.core.DB2Database;
import liquibase.database.core.MockDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RenameColumnStatement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RenameColumnChangeTest
extends AbstractChangeTest {
    RenameColumnChange refactoring;

    @Before
    public void setUp() throws Exception {
        this.refactoring = new RenameColumnChange();
        this.refactoring.setSchemaName("SCHEMA_NAME");
        this.refactoring.setTableName("TABLE_NAME");
        this.refactoring.setOldColumnName("oldColName");
        this.refactoring.setNewColumnName("newColName");
    }

    @Test
    public void getRefactoringName() throws Exception {
        Assert.assertEquals((Object)"Rename Column", (Object)this.refactoring.getChangeMetaData().getDescription());
    }

    @Test
    public void generateStatement() throws Exception {
        SqlStatement[] sqlStatements = this.refactoring.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)sqlStatements.length);
        Assert.assertTrue((boolean)(sqlStatements[0] instanceof RenameColumnStatement));
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)((RenameColumnStatement)sqlStatements[0]).getSchemaName());
        Assert.assertEquals((Object)"TABLE_NAME", (Object)((RenameColumnStatement)sqlStatements[0]).getTableName());
        Assert.assertEquals((Object)"oldColName", (Object)((RenameColumnStatement)sqlStatements[0]).getOldColumnName());
        Assert.assertEquals((Object)"newColName", (Object)((RenameColumnStatement)sqlStatements[0]).getNewColumnName());
    }

    @Test
    public void getConfirmationMessage() throws Exception {
        Assert.assertEquals((Object)"Column TABLE_NAME.oldColName renamed to newColName", (Object)this.refactoring.getConfirmationMessage());
    }

    protected boolean changeIsUnsupported(Database database) {
        return database instanceof DB2Database || database instanceof CacheDatabase || database instanceof SQLiteDatabase;
    }
}

