/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChangeTest;
import liquibase.change.core.RenameTableChange;
import liquibase.database.Database;
import liquibase.database.core.CacheDatabase;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.MockDatabase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RenameTableStatement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RenameTableChangeTest
extends AbstractChangeTest {
    private RenameTableChange refactoring;

    @Before
    public void setUp() throws Exception {
        this.refactoring = new RenameTableChange();
    }

    @Test
    public void getRefactoringName() throws Exception {
        Assert.assertEquals((Object)"Rename Table", (Object)this.refactoring.getChangeMetaData().getDescription());
    }

    @Test
    public void generateStatement() throws Exception {
        RenameTableChange refactoring = new RenameTableChange();
        refactoring.setSchemaName("SCHEMA_NAME");
        refactoring.setOldTableName("OLD_NAME");
        refactoring.setNewTableName("NEW_NAME");
        SqlStatement[] sqlStatements = refactoring.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)sqlStatements.length);
        Assert.assertTrue((boolean)(sqlStatements[0] instanceof RenameTableStatement));
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)((RenameTableStatement)sqlStatements[0]).getSchemaName());
        Assert.assertEquals((Object)"OLD_NAME", (Object)((RenameTableStatement)sqlStatements[0]).getOldTableName());
        Assert.assertEquals((Object)"NEW_NAME", (Object)((RenameTableStatement)sqlStatements[0]).getNewTableName());
    }

    @Test
    public void getConfirmationMessage() throws Exception {
        this.refactoring.setOldTableName("OLD_NAME");
        this.refactoring.setNewTableName("NEW_NAME");
        Assert.assertEquals((Object)"Table OLD_NAME renamed to NEW_NAME", (Object)this.refactoring.getConfirmationMessage());
    }

    protected boolean changeIsUnsupported(Database database) {
        return database instanceof CacheDatabase || database instanceof FirebirdDatabase;
    }
}

