/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChangeTest;
import liquibase.change.core.RenameViewChange;
import liquibase.database.Database;
import liquibase.database.core.CacheDatabase;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.H2Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.MockDatabase;
import liquibase.database.core.SybaseASADatabase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RenameViewStatement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RenameViewChangeTest
extends AbstractChangeTest {
    private RenameViewChange refactoring;

    @Before
    public void setUp() throws Exception {
        this.refactoring = new RenameViewChange();
    }

    @Test
    public void getRefactoringName() throws Exception {
        Assert.assertEquals((Object)"Rename View", (Object)this.refactoring.getChangeMetaData().getDescription());
    }

    @Test
    public void generateStatement() throws Exception {
        RenameViewChange refactoring = new RenameViewChange();
        refactoring.setSchemaName("SCHEMA_NAME");
        refactoring.setOldViewName("OLD_NAME");
        refactoring.setNewViewName("NEW_NAME");
        SqlStatement[] sqlStatements = refactoring.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)sqlStatements.length);
        Assert.assertTrue((boolean)(sqlStatements[0] instanceof RenameViewStatement));
        Assert.assertEquals((Object)"SCHEMA_NAME", (Object)((RenameViewStatement)sqlStatements[0]).getSchemaName());
        Assert.assertEquals((Object)"OLD_NAME", (Object)((RenameViewStatement)sqlStatements[0]).getOldViewName());
        Assert.assertEquals((Object)"NEW_NAME", (Object)((RenameViewStatement)sqlStatements[0]).getNewViewName());
    }

    @Test
    public void getConfirmationMessage() throws Exception {
        this.refactoring.setOldViewName("OLD_NAME");
        this.refactoring.setNewViewName("NEW_NAME");
        Assert.assertEquals((Object)"View OLD_NAME renamed to NEW_NAME", (Object)this.refactoring.getConfirmationMessage());
    }

    protected boolean changeIsUnsupported(Database database) {
        return database instanceof SybaseASADatabase || database instanceof InformixDatabase || database instanceof DerbyDatabase || database instanceof HsqlDatabase || database instanceof H2Database || database instanceof DB2Database || database instanceof CacheDatabase || database instanceof FirebirdDatabase;
    }
}

