/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.lang.reflect.Field;
import java.util.Map;
import liquibase.change.AbstractChangeTest;
import liquibase.change.Change;
import liquibase.change.core.SQLFileChange;
import liquibase.changelog.ChangeLogParameters;
import liquibase.database.Database;
import liquibase.database.core.MockDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.SetupException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLFileChangeTest
extends AbstractChangeTest {
    private SQLFileChange change;
    private String fileName;

    @Before
    public void setUp() throws Exception {
        this.fileName = "liquibase/change/core/SQLFileTestData.sql";
        this.change = new SQLFileChange();
        this.change.setSql("select * from tablename");
        ClassLoaderResourceAccessor opener = new ClassLoaderResourceAccessor();
        this.change.setResourceAccessor((ResourceAccessor)opener);
        this.change.setPath(this.fileName);
        this.change.init();
    }

    @Override
    public void generateStatement() throws Exception {
    }

    @Test
    public void multilineComment2() {
        String original = "--\r\n-- This is a comment\r\nUPDATE tablename SET column = 1;\r\nGO";
        SQLFileChange change = new SQLFileChange();
        change.setSql(original);
        change.setSplitStatements(Boolean.valueOf(true));
        change.setStripComments(Boolean.valueOf(true));
        SqlStatement[] out = change.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)2L, (long)out.length);
        Assert.assertEquals((Object)"UPDATE tablename SET column = 1", (Object)out[0].toString());
    }

    @Test
    public void setFileOpener() {
        Assert.assertNotNull((Object)this.change.getResourceAccessor());
    }

    @Test
    public void generateStatementFileNotFound() throws Exception {
        try {
            this.change.setPath("doesnotexist.sql");
            this.change.init();
            this.change.generateStatements((Database)new OracleDatabase());
            Assert.fail((String)"The file does not exist so should not be found");
        }
        catch (SetupException setupException) {
            // empty catch block
        }
    }

    @Override
    @Test
    public void getConfirmationMessage() throws Exception {
        this.change.setPath(this.fileName);
        Assert.assertEquals((Object)("SQL in file " + this.fileName + " executed"), (Object)this.change.getConfirmationMessage());
    }

    @Override
    @Test
    public void getRefactoringName() throws Exception {
        Assert.assertEquals((Object)"SQL From File", (Object)this.change.getChangeMetaData().getDescription());
    }

    @Test
    public void testStatementsWithSemicolons() {
        SQLFileChange change2 = new SQLFileChange();
        String insertWithSemicolon = "insert into table ( col ) values (' value with; semicolon ');";
        change2.setSql(insertWithSemicolon);
        MockDatabase database = new MockDatabase();
        SqlStatement[] statements = change2.generateStatements((Database)database);
        Assert.assertEquals((String)"Unexpected amount of statements returned", (long)1L, (long)statements.length);
        String insertWithoutTrailingSemicolon = insertWithSemicolon.substring(0, insertWithSemicolon.length() - 1);
        Assert.assertEquals((String)"unexpected SQL statement returned", (Object)insertWithoutTrailingSemicolon, (Object)statements[0].toString());
    }

    @Override
    protected void checkThatChecksumIsNew(Change change, Map<String, String> seenCheckSums, Field field) {
    }

    @Test
    public void replacementOfProperties() throws Exception {
        SQLFileChange change = new SQLFileChange();
        ChangeLogParameters changeLogParameters = new ChangeLogParameters();
        changeLogParameters.set("table.prefix", (Object)"prfx");
        changeLogParameters.set("some.other.prop", (Object)"nofx");
        change.setChangeLogParameters(changeLogParameters);
        String fakeSql = "create ${table.prefix}_customer (${some.other.prop} INTEGER NOT NULL, PRIMARY KEY (${some.other.prop}));";
        change.setSql(fakeSql);
        String expected = "create prfx_customer (nofx INTEGER NOT NULL, PRIMARY KEY (nofx));";
        Assert.assertEquals((Object)expected, (Object)change.getSql());
    }
}

