/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChangeTest;
import liquibase.change.core.TagDatabaseChange;
import liquibase.database.Database;
import liquibase.database.core.MockDatabase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.TagDatabaseStatement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TagDatabaseChangeTest
extends AbstractChangeTest {
    private TagDatabaseChange refactoring;

    @Before
    public void setUp() throws Exception {
        this.refactoring = new TagDatabaseChange();
    }

    @Test
    public void getRefactoringName() throws Exception {
        Assert.assertEquals((Object)"Tag Database", (Object)this.refactoring.getChangeMetaData().getDescription());
    }

    @Test
    public void generateStatement() throws Exception {
        TagDatabaseChange refactoring = new TagDatabaseChange();
        refactoring.setTag("TAG_NAME");
        SqlStatement[] sqlStatements = refactoring.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)sqlStatements.length);
        Assert.assertTrue((boolean)(sqlStatements[0] instanceof TagDatabaseStatement));
        Assert.assertEquals((Object)"TAG_NAME", (Object)((TagDatabaseStatement)sqlStatements[0]).getTag());
    }

    @Test
    public void getConfirmationMessage() throws Exception {
        this.refactoring.setTag("TAG_NAME");
        Assert.assertEquals((Object)"Tag 'TAG_NAME' applied to database", (Object)this.refactoring.getConfirmationMessage());
    }
}

