/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.custom;

import liquibase.change.custom.CustomSqlChange;
import liquibase.change.custom.CustomSqlRollback;
import liquibase.database.Database;
import liquibase.exception.RollbackImpossibleException;
import liquibase.exception.SetupException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;

public class ExampleCustomSqlChange
implements CustomSqlChange,
CustomSqlRollback {
    private String tableName;
    private String columnName;
    private String newValue;
    private ResourceAccessor resourceAccessor;

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new RawSqlStatement("update " + this.tableName + " set " + this.columnName + " = " + this.newValue)};
    }

    public SqlStatement[] generateRollbackStatements(Database database) throws UnsupportedChangeException, RollbackImpossibleException {
        return new SqlStatement[]{new RawSqlStatement("update " + this.tableName + " set " + this.columnName + " = null")};
    }

    public String getConfirmationMessage() {
        return "Custom class updated " + this.tableName + "." + this.columnName;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
        this.resourceAccessor = resourceAccessor;
    }

    public ValidationErrors validate(Database database) {
        return new ValidationErrors();
    }
}

