/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.util.ArrayList;
import java.util.List;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.database.Database;
import liquibase.database.core.MySQLDatabase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChangeLogIteratorTest {
    private DatabaseChangeLog changeLog;

    @Before
    public void setUp() {
        this.changeLog = new DatabaseChangeLog();
        this.changeLog.addChangeSet(new ChangeSet("1", "nvoxland", false, false, "/path/to/changelog", "test1", "mysql"));
        this.changeLog.addChangeSet(new ChangeSet("2", "nvoxland", false, false, "/path/to/changelog", "test1", "oracle"));
        this.changeLog.addChangeSet(new ChangeSet("3", "nvoxland", false, false, "/path/to/changelog", "test2", "mysql"));
        this.changeLog.addChangeSet(new ChangeSet("4", "nvoxland", false, false, "/path/to/changelog", null, null));
        this.changeLog.addChangeSet(new ChangeSet("5", "nvoxland", false, false, "/path/to/changelog", null, "mysql"));
        this.changeLog.addChangeSet(new ChangeSet("6", "nvoxland", false, false, "/path/to/changelog", "test2", null));
    }

    @Test
    public void runChangeSet_emptyFiltersIterator() throws Exception {
        TestChangeSetVisitor testChangeLogVisitor = new TestChangeSetVisitor();
        ChangeLogIterator iterator = new ChangeLogIterator(this.changeLog, new ChangeSetFilter[0]);
        iterator.run((ChangeSetVisitor)testChangeLogVisitor, null);
        Assert.assertEquals((long)6L, (long)testChangeLogVisitor.visitedChangeSets.size());
    }

    @Test
    public void runChangeSet_singleFilterIterator() throws Exception {
        TestChangeSetVisitor testChangeLogVisitor = new TestChangeSetVisitor();
        ChangeLogIterator iterator = new ChangeLogIterator(this.changeLog, new ChangeSetFilter[]{new ContextChangeSetFilter(new String[]{"test1"})});
        iterator.run((ChangeSetVisitor)testChangeLogVisitor, null);
        Assert.assertEquals((long)4L, (long)testChangeLogVisitor.visitedChangeSets.size());
    }

    @Test
    public void runChangeSet_doubleFilterIterator() throws Exception {
        TestChangeSetVisitor testChangeLogVisitor = new TestChangeSetVisitor();
        ChangeLogIterator iterator = new ChangeLogIterator(this.changeLog, new ChangeSetFilter[]{new ContextChangeSetFilter(new String[]{"test1"}), new DbmsChangeSetFilter((Database)new MySQLDatabase())});
        iterator.run((ChangeSetVisitor)testChangeLogVisitor, null);
        Assert.assertEquals((long)3L, (long)testChangeLogVisitor.visitedChangeSets.size());
        Assert.assertEquals((Object)"1", (Object)testChangeLogVisitor.visitedChangeSets.get(0).getId());
        Assert.assertEquals((Object)"4", (Object)testChangeLogVisitor.visitedChangeSets.get(1).getId());
        Assert.assertEquals((Object)"5", (Object)testChangeLogVisitor.visitedChangeSets.get(2).getId());
    }

    @Test
    public void runChangeSet_reverseVisitor() throws Exception {
        ReverseChangeSetVisitor testChangeLogVisitor = new ReverseChangeSetVisitor();
        ChangeLogIterator iterator = new ChangeLogIterator(this.changeLog, new ChangeSetFilter[]{new ContextChangeSetFilter(new String[]{"test1"}), new DbmsChangeSetFilter((Database)new MySQLDatabase())});
        iterator.run((ChangeSetVisitor)testChangeLogVisitor, null);
        Assert.assertEquals((long)3L, (long)testChangeLogVisitor.visitedChangeSets.size());
        Assert.assertEquals((Object)"5", (Object)testChangeLogVisitor.visitedChangeSets.get(0).getId());
        Assert.assertEquals((Object)"4", (Object)testChangeLogVisitor.visitedChangeSets.get(1).getId());
        Assert.assertEquals((Object)"1", (Object)testChangeLogVisitor.visitedChangeSets.get(2).getId());
    }

    private static class ReverseChangeSetVisitor
    extends TestChangeSetVisitor {
        private ReverseChangeSetVisitor() {
        }

        public ChangeSetVisitor.Direction getDirection() {
            return ChangeSetVisitor.Direction.REVERSE;
        }
    }

    private static class TestChangeSetVisitor
    implements ChangeSetVisitor {
        public List<ChangeSet> visitedChangeSets = new ArrayList<ChangeSet>();

        private TestChangeSetVisitor() {
        }

        public ChangeSetVisitor.Direction getDirection() {
            return ChangeSetVisitor.Direction.FORWARD;
        }

        public void visit(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database) {
            this.visitedChangeSets.add(changeSet);
        }
    }
}

