/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.util.Arrays;
import liquibase.changelog.ChangeLogParameters;
import liquibase.database.Database;
import liquibase.database.core.H2Database;
import org.junit.Assert;
import org.junit.Test;

public class ChangeLogParametersTest {
    @Test
    public void setParameterValue_doubleSet() {
        ChangeLogParameters changeLogParameters = new ChangeLogParameters();
        changeLogParameters.set("doubleSet", (Object)"originalValue");
        changeLogParameters.set("doubleSet", (Object)"newValue");
        Assert.assertEquals((String)"re-setting a param should not overwrite the value (like how ant works)", (Object)"originalValue", (Object)changeLogParameters.getValue("doubleSet"));
    }

    @Test
    public void getParameterValue_systemProperty() {
        ChangeLogParameters changeLogParameters = new ChangeLogParameters();
        Assert.assertEquals((Object)System.getProperty("user.name"), (Object)changeLogParameters.getValue("user.name"));
    }

    @Test
    public void setParameterValue_doubleSetButSecondWrongDatabase() {
        ChangeLogParameters changeLogParameters = new ChangeLogParameters((Database)new H2Database());
        changeLogParameters.set("doubleSet", "originalValue", null, "baddb");
        changeLogParameters.set("doubleSet", (Object)"newValue");
        Assert.assertEquals((Object)"newValue", (Object)changeLogParameters.getValue("doubleSet"));
    }

    @Test
    public void setParameterValue_multiDatabase() {
        ChangeLogParameters changeLogParameters = new ChangeLogParameters((Database)new H2Database());
        changeLogParameters.set("doubleSet", "originalValue", null, "baddb, h2");
        Assert.assertEquals((Object)"originalValue", (Object)changeLogParameters.getValue("doubleSet"));
    }

    @Test
    public void setParameterValue_rightDBWrongContext() {
        ChangeLogParameters changeLogParameters = new ChangeLogParameters((Database)new H2Database());
        changeLogParameters.setContexts(Arrays.asList("junit"));
        changeLogParameters.set("doubleSet", "originalValue", "anotherContext", "baddb, h2");
        Assert.assertNull((Object)changeLogParameters.getValue("doubleSet"));
    }

    @Test
    public void setParameterValue_rightDBRightContext() {
        ChangeLogParameters changeLogParameters = new ChangeLogParameters((Database)new H2Database());
        changeLogParameters.setContexts(Arrays.asList("junit"));
        changeLogParameters.set("doubleSet", "originalValue", "junit", "baddb, h2");
        Assert.assertEquals((Object)"originalValue", (Object)changeLogParameters.getValue("doubleSet"));
    }
}

