/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.util.List;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.ChangeLogParseException;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.parser.core.sql.SqlChangeLogParser;
import liquibase.parser.core.xml.XMLChangeLogSAXParser;
import liquibase.resource.ResourceAccessor;
import liquibase.test.JUnitResourceAccessor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ChangeLogParserFactoryTest {
    @After
    public void teardown() {
        ChangeLogParserFactory.reset();
    }

    @Test
    public void getInstance() {
        Assert.assertNotNull((Object)ChangeLogParserFactory.getInstance());
        Assert.assertTrue((ChangeLogParserFactory.getInstance() == ChangeLogParserFactory.getInstance() ? 1 : 0) != 0);
    }

    @Test
    public void register() {
        ChangeLogParserFactory.getInstance().getParsers().clear();
        Assert.assertEquals((long)0L, (long)ChangeLogParserFactory.getInstance().getParsers().size());
        ChangeLogParserFactory.getInstance().register((ChangeLogParser)new MockChangeLogParser());
        Assert.assertEquals((long)1L, (long)ChangeLogParserFactory.getInstance().getParsers().size());
    }

    @Test
    public void unregister_instance() {
        ChangeLogParserFactory factory = ChangeLogParserFactory.getInstance();
        factory.getParsers().clear();
        Assert.assertEquals((long)0L, (long)factory.getParsers().size());
        MockChangeLogParser mockChangeLogParser = new MockChangeLogParser();
        factory.register((ChangeLogParser)new XMLChangeLogSAXParser());
        factory.register((ChangeLogParser)mockChangeLogParser);
        factory.register((ChangeLogParser)new SqlChangeLogParser());
        Assert.assertEquals((long)3L, (long)factory.getParsers().size());
        factory.unregister((ChangeLogParser)mockChangeLogParser);
        Assert.assertEquals((long)2L, (long)factory.getParsers().size());
    }

    @Test
    public void getParser_byExtension() throws Exception {
        ChangeLogParserFactory.getInstance().getParsers().clear();
        XMLChangeLogSAXParser xmlChangeLogParser = new XMLChangeLogSAXParser();
        ChangeLogParserFactory.getInstance().register((ChangeLogParser)xmlChangeLogParser);
        ChangeLogParserFactory.getInstance().register((ChangeLogParser)new SqlChangeLogParser());
        ChangeLogParser parser = ChangeLogParserFactory.getInstance().getParser("xml", (ResourceAccessor)new JUnitResourceAccessor());
        Assert.assertNotNull((Object)parser);
        Assert.assertTrue((xmlChangeLogParser == parser ? 1 : 0) != 0);
    }

    @Test
    public void getParser_byFile() throws Exception {
        ChangeLogParserFactory.getInstance().getParsers().clear();
        XMLChangeLogSAXParser xmlChangeLogParser = new XMLChangeLogSAXParser();
        ChangeLogParserFactory.getInstance().register((ChangeLogParser)xmlChangeLogParser);
        ChangeLogParserFactory.getInstance().register((ChangeLogParser)new SqlChangeLogParser());
        ChangeLogParser parser = ChangeLogParserFactory.getInstance().getParser("path/to/a/file.xml", (ResourceAccessor)new JUnitResourceAccessor());
        Assert.assertNotNull((Object)parser);
        Assert.assertTrue((xmlChangeLogParser == parser ? 1 : 0) != 0);
    }

    @Test
    public void getParser_noneMatching() throws Exception {
        ChangeLogParserFactory.getInstance().getParsers().clear();
        ChangeLogParserFactory.getInstance().getParsers().clear();
        XMLChangeLogSAXParser xmlChangeLogParser = new XMLChangeLogSAXParser();
        ChangeLogParserFactory.getInstance().register((ChangeLogParser)xmlChangeLogParser);
        ChangeLogParserFactory.getInstance().register((ChangeLogParser)new SqlChangeLogParser());
        try {
            ChangeLogParserFactory.getInstance().getParser("badextension", (ResourceAccessor)new JUnitResourceAccessor());
            Assert.fail((String)"Did not throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void reset() {
        ChangeLogParserFactory instance1 = ChangeLogParserFactory.getInstance();
        ChangeLogParserFactory.reset();
        Assert.assertFalse((instance1 == ChangeLogParserFactory.getInstance() ? 1 : 0) != 0);
    }

    @Test
    public void builtInGeneratorsAreFound() {
        List parsers = ChangeLogParserFactory.getInstance().getParsers();
        Assert.assertTrue((parsers.size() > 0 ? 1 : 0) != 0);
    }

    private static class MockChangeLogParser
    implements ChangeLogParser {
        private MockChangeLogParser() {
        }

        public DatabaseChangeLog parse(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, ResourceAccessor resourceAccessor) throws ChangeLogParseException {
            return null;
        }

        public boolean supports(String changeLogFile, ResourceAccessor resourceAccessor) {
            return changeLogFile.endsWith(".test");
        }

        public int getPriority() {
            return 1;
        }
    }
}

