/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class ChangeSetExecuteTest {
    private void trainToAcceptAnyNumberOfCommitsOrRollbacks(Database database) {
        try {
            database.commit();
            EasyMock.expectLastCall().anyTimes();
            database.rollback();
            EasyMock.expectLastCall().anyTimes();
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    private Database createMockDatabaseThatSupportsDdlInTran() {
        Database database = (Database)EasyMock.createMock(Database.class);
        EasyMock.expect((Object)database.supportsDDLInTransaction()).andStubReturn((Object)true);
        EasyMock.expect((Object)database.getAutoCommitMode()).andStubReturn((Object)false);
        return database;
    }

    private Database createMockDatabaseThatDoesNotSupportDdlInTran() {
        Database database = (Database)EasyMock.createMock(Database.class);
        EasyMock.expect((Object)database.supportsDDLInTransaction()).andStubReturn((Object)false);
        EasyMock.expect((Object)database.getAutoCommitMode()).andStubReturn((Object)true);
        return database;
    }

    private Executor createMockExecutor() {
        Executor executor = (Executor)EasyMock.createNiceMock(Executor.class);
        EasyMock.replay((Object[])new Object[]{executor});
        return executor;
    }

    private ChangeSet createTestChangeSet(boolean runInTransaction) {
        return new ChangeSet("test-id", "test-author", false, false, "/test.xml", null, null, runInTransaction);
    }

    @Test
    public void testMockDatabaseThatSupportsDdlInTran() {
        Database database = this.createMockDatabaseThatSupportsDdlInTran();
        EasyMock.replay((Object[])new Object[]{database});
        Assert.assertTrue((boolean)database.supportsDDLInTransaction());
        Assert.assertFalse((boolean)database.getAutoCommitMode());
    }

    @Test
    public void testMockDatabaseThatDoesNotSupportDdlInTran() {
        Database database = this.createMockDatabaseThatDoesNotSupportDdlInTran();
        EasyMock.replay((Object[])new Object[]{database});
        Assert.assertFalse((boolean)database.supportsDDLInTransaction());
        Assert.assertTrue((boolean)database.getAutoCommitMode());
    }

    @Test
    public void testExecuteForDatabaseThatSupportsDdlInTranWhenRunInTransactionIsTrue() throws Exception {
        Database database = this.createMockDatabaseThatSupportsDdlInTran();
        ExecutorService.getInstance().setExecutor(database, this.createMockExecutor());
        EasyMock.checkOrder((Object)database, (boolean)true);
        database.setAutoCommit(false);
        EasyMock.checkOrder((Object)database, (boolean)false);
        this.trainToAcceptAnyNumberOfCommitsOrRollbacks(database);
        EasyMock.replay((Object[])new Object[]{database});
        ChangeSet changeSet = this.createTestChangeSet(true);
        changeSet.execute(new DatabaseChangeLog(), database);
        EasyMock.verify((Object[])new Object[]{database});
    }

    @Test
    public void testExecuteForDatabaseThatSupportsDdlInTranWhenRunInTransactionIsFalse() throws Exception {
        Database database = this.createMockDatabaseThatSupportsDdlInTran();
        ExecutorService.getInstance().setExecutor(database, this.createMockExecutor());
        EasyMock.checkOrder((Object)database, (boolean)true);
        database.setAutoCommit(true);
        EasyMock.checkOrder((Object)database, (boolean)false);
        this.trainToAcceptAnyNumberOfCommitsOrRollbacks(database);
        EasyMock.checkOrder((Object)database, (boolean)true);
        database.setAutoCommit(false);
        EasyMock.replay((Object[])new Object[]{database});
        ChangeSet changeSet = this.createTestChangeSet(false);
        changeSet.execute(new DatabaseChangeLog(), database);
        EasyMock.verify((Object[])new Object[]{database});
    }

    @Test
    public void testExecuteForDatabaseThatDoesNotSupportDdlInTranWhenRunInTransactionIsTrue() throws Exception {
        Database database = this.createMockDatabaseThatDoesNotSupportDdlInTran();
        ExecutorService.getInstance().setExecutor(database, this.createMockExecutor());
        this.trainToAcceptAnyNumberOfCommitsOrRollbacks(database);
        EasyMock.replay((Object[])new Object[]{database});
        ChangeSet changeSet = this.createTestChangeSet(true);
        changeSet.execute(new DatabaseChangeLog(), database);
        EasyMock.verify((Object[])new Object[]{database});
    }

    @Test
    public void testExecuteForDatabaseThatDoesNotSupportDdlInTranWhenRunInTransactionIsFalse() throws Exception {
        Database database = this.createMockDatabaseThatDoesNotSupportDdlInTran();
        ExecutorService.getInstance().setExecutor(database, this.createMockExecutor());
        this.trainToAcceptAnyNumberOfCommitsOrRollbacks(database);
        EasyMock.replay((Object[])new Object[]{database});
        ChangeSet changeSet = this.createTestChangeSet(false);
        changeSet.execute(new DatabaseChangeLog(), database);
        EasyMock.verify((Object[])new Object[]{database});
    }
}

