/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import liquibase.change.Change;
import liquibase.change.CheckSum;
import liquibase.change.core.AddDefaultValueChange;
import liquibase.change.core.CreateTableChange;
import liquibase.change.core.InsertDataChange;
import liquibase.changelog.ChangeSet;
import org.junit.Assert;
import org.junit.Test;

public class ChangeSetTest {
    @Test
    public void getDescriptions() {
        ChangeSet changeSet = new ChangeSet("testId", "testAuthor", false, false, null, null, null);
        Assert.assertEquals((Object)"Empty", (Object)changeSet.getDescription());
        changeSet.addChange((Change)new InsertDataChange());
        Assert.assertEquals((Object)"Insert Row", (Object)changeSet.getDescription());
        changeSet.addChange((Change)new InsertDataChange());
        Assert.assertEquals((Object)"Insert Row (x2)", (Object)changeSet.getDescription());
        changeSet.addChange((Change)new CreateTableChange());
        Assert.assertEquals((Object)"Insert Row (x2), Create Table", (Object)changeSet.getDescription());
    }

    @Test
    public void generateCheckSum() {
        ChangeSet changeSet1 = new ChangeSet("testId", "testAuthor", false, false, null, null, null);
        ChangeSet changeSet2 = new ChangeSet("testId", "testAuthor", false, false, null, null, null);
        AddDefaultValueChange change = new AddDefaultValueChange();
        change.setSchemaName("SCHEMA_NAME");
        change.setTableName("TABLE_NAME");
        change.setColumnName("COLUMN_NAME");
        change.setDefaultValue("DEF STRING");
        change.setDefaultValueNumeric("42");
        change.setDefaultValueBoolean(Boolean.valueOf(true));
        change.setDefaultValueDate("2007-01-02");
        changeSet1.addChange((Change)change);
        changeSet2.addChange((Change)change);
        CheckSum md5Sum1 = changeSet1.generateCheckSum();
        change.setSchemaName("SCHEMA_NAME2");
        CheckSum md5Sum2 = changeSet2.generateCheckSum();
        Assert.assertFalse((boolean)md5Sum1.equals((Object)md5Sum2));
    }

    @Test
    public void isCheckSumValid_validCheckSum() {
        ChangeSet changeSet = new ChangeSet("1", "2", false, false, "/test.xml", null, null);
        CheckSum checkSum = changeSet.generateCheckSum();
        Assert.assertTrue((boolean)changeSet.isCheckSumValid(checkSum));
    }

    @Test
    public void isCheckSumValid_invalidCheckSum() {
        CheckSum checkSum = CheckSum.parse((String)"2:asdf");
        ChangeSet changeSet = new ChangeSet("1", "2", false, false, "/test.xml", null, null);
        Assert.assertFalse((boolean)changeSet.isCheckSumValid(checkSum));
    }

    @Test
    public void isCheckSumValid_differentButValidCheckSum() {
        CheckSum checkSum = CheckSum.parse((String)"2:asdf");
        ChangeSet changeSet = new ChangeSet("1", "2", false, false, "/test.xml", null, null);
        changeSet.addValidCheckSum(changeSet.generateCheckSum().toString());
        Assert.assertTrue((boolean)changeSet.isCheckSumValid(checkSum));
    }
}

