/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import liquibase.changelog.ChangeLogParameters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExpressionExpanderTest {
    private ChangeLogParameters.ExpressionExpander handler;
    private ChangeLogParameters changeLogParameters;

    @Before
    public void setup() {
        this.changeLogParameters = new ChangeLogParameters();
        this.handler = new ChangeLogParameters.ExpressionExpander(this.changeLogParameters);
    }

    @Test
    public void expandExpressions_nullValue() {
        Assert.assertNull((Object)this.handler.expandExpressions(null));
    }

    @Test
    public void expandExpressions_emptyString() {
        Assert.assertEquals((Object)"", (Object)this.handler.expandExpressions(""));
    }

    @Test
    public void expandExpressions_noExpression() {
        Assert.assertEquals((Object)"A Simple String", (Object)this.handler.expandExpressions("A Simple String"));
    }

    @Test
    public void expandExpressions_singleObjectExpression() {
        this.changeLogParameters.set("here", (Object)4);
        Assert.assertEquals((Object)"A string with one expression 4 set", (Object)this.handler.expandExpressions("A string with one expression ${here} set"));
    }

    @Test
    public void expandExpressions_doubleObjectExpression() {
        this.changeLogParameters.set("here", (Object)4);
        this.changeLogParameters.set("there", (Object)15);
        Assert.assertEquals((Object)"A string with two expressions 4 and 15 set", (Object)this.handler.expandExpressions("A string with two expressions ${here} and ${there} set"));
    }

    @Test
    public void expandExpressions_nomatchExpression() {
        Assert.assertEquals((Object)"A string no expressions ${notset} set", (Object)this.handler.expandExpressions("A string no expressions ${notset} set"));
        Assert.assertEquals((Object)"A string no expressions ${notset.orParams} set", (Object)this.handler.expandExpressions("A string no expressions ${notset.orParams} set"));
    }
}

