/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.filter;

import java.util.ArrayList;
import java.util.Date;
import liquibase.change.CheckSum;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.AlreadyRanChangeSetFilter;
import org.junit.Assert;
import org.junit.Test;

public class AlreadyRanChangeSetFilterTest {
    @Test
    public void accepts_noneRun() {
        AlreadyRanChangeSetFilter filter = new AlreadyRanChangeSetFilter(new ArrayList());
        Assert.assertFalse((boolean)filter.accepts(new ChangeSet("1", "testAuthor", false, false, "path/changelog", null, null)));
    }

    @Test
    public void accepts() {
        ArrayList<RanChangeSet> ranChanges = new ArrayList<RanChangeSet>();
        ranChanges.add(new RanChangeSet("path/changelog", "1", "testAuthor", CheckSum.parse((String)"12345"), new Date(), null, null));
        ranChanges.add(new RanChangeSet("path/changelog", "2", "testAuthor", CheckSum.parse((String)"12345"), new Date(), null, null));
        AlreadyRanChangeSetFilter filter = new AlreadyRanChangeSetFilter(ranChanges);
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet("1", "testAuthor", false, false, "path/changelog", null, null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet("1", "testAuthor", true, false, "path/changelog", null, null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet("1", "testAuthor", false, true, "path/changelog", null, null)));
        Assert.assertFalse((boolean)filter.accepts(new ChangeSet("3", "testAuthor", false, false, "path/changelog", null, null)));
        Assert.assertFalse((boolean)filter.accepts(new ChangeSet("1", "otherAuthor", false, false, "path/changelog", null, null)));
        Assert.assertFalse((boolean)filter.accepts(new ChangeSet("1", "testAuthor", false, false, "other/changelog", null, null)));
    }
}

