/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.filter;

import liquibase.changelog.ChangeSet;
import liquibase.changelog.filter.ContextChangeSetFilter;
import org.junit.Assert;
import org.junit.Test;

public class ContextChangeSetFilterTest {
    @Test
    public void emptyContexts() {
        ContextChangeSetFilter filter = new ContextChangeSetFilter(new String[0]);
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, "test1", null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, "test2", null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, "test1, test2", null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, null, null)));
    }

    @Test
    public void nullContexts() {
        ContextChangeSetFilter filter = new ContextChangeSetFilter(new String[0]);
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, "test1", null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, "test2", null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, "test1, test2", null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, null, null)));
    }

    @Test
    public void nullListContexts() {
        ContextChangeSetFilter filter = new ContextChangeSetFilter(new String[0]);
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, "test1", null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, "test2", null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, "test1, test2", null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, null, null)));
    }

    @Test
    public void singleContexts() {
        ContextChangeSetFilter filter = new ContextChangeSetFilter(new String[]{"TEST1"});
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, "test1", null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, "test1, test2", null)));
        Assert.assertFalse((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, "test2", null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, null, null)));
    }

    @Test
    public void multiContexts() {
        ContextChangeSetFilter filter = new ContextChangeSetFilter(new String[]{"test1", "test2"});
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, "test1", null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, "test2", null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, "test1, test2", null)));
        Assert.assertFalse((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, "test3", null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, "test3, test1", null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, "test3, TEST1", null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, null, null)));
    }

    @Test
    public void multiContextsSingeParameter() {
        ContextChangeSetFilter filter = new ContextChangeSetFilter(new String[]{"test1, test2"});
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, "test1", null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, "test2", null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, "test1, test2", null)));
        Assert.assertFalse((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, "test3", null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, "test3, test1", null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, "test3, TEST1", null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet(null, null, false, false, null, null, null)));
    }
}

