/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.filter;

import java.util.ArrayList;
import java.util.Date;
import liquibase.change.CheckSum;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ExecutedAfterChangeSetFilter;
import org.junit.Assert;
import org.junit.Test;

public class ExecutedAfterChangeSetFilterTest {
    @Test
    public void accepts_noRan() throws Exception {
        ExecutedAfterChangeSetFilter filter = new ExecutedAfterChangeSetFilter(new Date(), new ArrayList());
        Assert.assertFalse((boolean)filter.accepts(new ChangeSet("1", "testAuthor", false, false, "path/changelog", null, null)));
    }

    @Test
    public void accepts_nullDate() throws Exception {
        ArrayList<RanChangeSet> ranChanges = new ArrayList<RanChangeSet>();
        ranChanges.add(new RanChangeSet("path/changelog", "1", "testAuthor", CheckSum.parse((String)"12345"), new Date(), null, null));
        ranChanges.add(new RanChangeSet("path/changelog", "2", "testAuthor", CheckSum.parse((String)"12345"), null, null, null));
        ranChanges.add(new RanChangeSet("path/changelog", "3", "testAuthor", CheckSum.parse((String)"12345"), new Date(), null, null));
        ExecutedAfterChangeSetFilter filter = new ExecutedAfterChangeSetFilter(new Date(), ranChanges);
        Assert.assertFalse((boolean)filter.accepts(new ChangeSet("1", "testAuthor", false, false, "path/changelog", null, null)));
    }

    @Test
    public void accepts() throws Exception {
        ArrayList<RanChangeSet> ranChanges = new ArrayList<RanChangeSet>();
        ranChanges.add(new RanChangeSet("path/changelog", "1", "testAuthor", CheckSum.parse((String)"12345"), new Date(new Date().getTime() - 36000000L), null, null));
        ranChanges.add(new RanChangeSet("path/changelog", "2", "testAuthor", CheckSum.parse((String)"12345"), new Date(new Date().getTime() - 28800000L), null, null));
        ranChanges.add(new RanChangeSet("path/changelog", "3", "testAuthor", CheckSum.parse((String)"12345"), new Date(new Date().getTime() - 14400000L), null, null));
        ExecutedAfterChangeSetFilter filter = new ExecutedAfterChangeSetFilter(new Date(new Date().getTime() - 21600000L), ranChanges);
        Assert.assertFalse((boolean)filter.accepts(new ChangeSet("1", "testAuthor", false, false, "path/changelog", null, null)));
        Assert.assertFalse((boolean)filter.accepts(new ChangeSet("2", "testAuthor", false, false, "path/changelog", null, null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet("3", "testAuthor", false, false, "path/changelog", null, null)));
    }
}

