/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.filter;

import java.util.ArrayList;
import java.util.Date;
import liquibase.change.CheckSum;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ShouldRunChangeSetFilter;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.UpdateStatement;
import org.easymock.classextension.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class ShouldRunChangeSetFilterTest {
    @Test
    public void accepts_noneRun() throws DatabaseException {
        Database database = (Database)EasyMock.createMock(Database.class);
        org.easymock.EasyMock.expect((Object)database.getRanChangeSetList()).andReturn(new ArrayList());
        EasyMock.replay((Object)database);
        ShouldRunChangeSetFilter filter = new ShouldRunChangeSetFilter(database);
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet("1", "testAuthor", false, false, "path/changelog", null, null)));
    }

    @Test
    public void accepts() throws DatabaseException {
        ArrayList<RanChangeSet> ranChanges = new ArrayList<RanChangeSet>();
        ranChanges.add(new RanChangeSet("path/changelog", "1", "testAuthor", CheckSum.parse((String)"12345"), new Date(), null, null));
        ranChanges.add(new RanChangeSet("path/changelog", "2", "testAuthor", CheckSum.parse((String)"12345"), new Date(), null, null));
        Database database = (Database)EasyMock.createMock(Database.class);
        org.easymock.EasyMock.expect((Object)database.getRanChangeSetList()).andReturn(ranChanges);
        org.easymock.EasyMock.expect((Object)database.getDatabaseChangeLogTableName()).andReturn((Object)"DATABASECHANGELOG").anyTimes();
        org.easymock.EasyMock.expect((Object)database.getDefaultSchemaName()).andReturn(null).anyTimes();
        Executor template = (Executor)EasyMock.createMock(Executor.class);
        org.easymock.EasyMock.expect((Object)template.update((SqlStatement)org.easymock.EasyMock.isA(UpdateStatement.class))).andReturn((Object)1).anyTimes();
        EasyMock.replay((Object)database);
        EasyMock.replay((Object)template);
        ExecutorService.getInstance().setExecutor(database, template);
        ShouldRunChangeSetFilter filter = new ShouldRunChangeSetFilter(database);
        Assert.assertFalse((boolean)filter.accepts(new ChangeSet("1", "testAuthor", false, false, "path/changelog", null, null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet("1", "testAuthor", true, false, "path/changelog", null, null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet("1", "testAuthor", false, true, "path/changelog", null, null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet("3", "testAuthor", false, false, "path/changelog", null, null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet("1", "otherAuthor", false, false, "path/changelog", null, null)));
        Assert.assertTrue((boolean)filter.accepts(new ChangeSet("1", "testAuthor", false, false, "other/changelog", null, null)));
    }
}

