/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.visitor;

import java.util.ArrayList;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.core.CreateTableChange;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.ValidatingVisitor;
import liquibase.exception.SetupException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ValidatingVisitorTest {
    private ChangeSet changeSet1;
    private ChangeSet changeSet2;

    @Before
    public void setup() {
        this.changeSet1 = new ChangeSet("1", "testAuthor", false, false, "path/changelog", null, null);
        this.changeSet2 = new ChangeSet("2", "testAuthor", false, false, "path/changelog", null, null);
    }

    @Test
    public void visit_successful() {
        CreateTableChange change1 = new CreateTableChange();
        change1.setTableName("table1");
        ColumnConfig column1 = new ColumnConfig();
        change1.addColumn(column1);
        column1.setName("col1");
        column1.setType("int");
        CreateTableChange change2 = new CreateTableChange();
        change2.setTableName("table2");
        ColumnConfig column2 = new ColumnConfig();
        change2.addColumn(column2);
        column2.setName("col2");
        column2.setType("int");
        this.changeSet1.addChange((Change)change1);
        this.changeSet2.addChange((Change)change2);
        ValidatingVisitor handler = new ValidatingVisitor(new ArrayList());
        handler.visit(this.changeSet1, new DatabaseChangeLog(), null);
        handler.visit(this.changeSet2, new DatabaseChangeLog(), null);
        Assert.assertTrue((boolean)handler.validationPassed());
    }

    @Test
    public void visit_setupException() {
        this.changeSet1.addChange((Change)new CreateTableChange(){

            public void init() throws SetupException {
                throw new SetupException("Test message");
            }
        });
        ValidatingVisitor handler = new ValidatingVisitor(new ArrayList());
        handler.visit(this.changeSet1, new DatabaseChangeLog(), null);
        Assert.assertEquals((long)1L, (long)handler.getSetupExceptions().size());
        Assert.assertEquals((Object)"Test message", (Object)((SetupException)((Object)handler.getSetupExceptions().get(0))).getMessage());
        Assert.assertFalse((boolean)handler.validationPassed());
    }

    @Test
    public void visit_duplicate() {
        ValidatingVisitor handler = new ValidatingVisitor(new ArrayList());
        handler.visit(this.changeSet1, new DatabaseChangeLog(), null);
        handler.visit(this.changeSet1, new DatabaseChangeLog(), null);
        Assert.assertEquals((long)1L, (long)handler.getDuplicateChangeSets().size());
        Assert.assertFalse((boolean)handler.validationPassed());
    }
}

