/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import liquibase.database.AbstractDatabase;
import liquibase.database.DatabaseConnection;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractDatabaseTest {
    protected AbstractDatabase database;

    protected AbstractDatabaseTest(AbstractDatabase database) throws Exception {
        this.database = database;
    }

    public AbstractDatabase getDatabase() {
        return this.database;
    }

    protected abstract String getProductNameString();

    public abstract void supportsInitiallyDeferrableColumns();

    public abstract void getCurrentDateTimeFunction();

    @Test
    public void isCorrectDatabaseImplementation() throws Exception {
        Assert.assertTrue((boolean)this.getDatabase().isCorrectDatabaseImplementation(this.getMockConnection()));
    }

    protected DatabaseConnection getMockConnection() throws Exception {
        DatabaseConnection conn = (DatabaseConnection)EasyMock.createMock(DatabaseConnection.class);
        conn.setAutoCommit(false);
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)conn.getDatabaseProductName()).andReturn((Object)this.getProductNameString()).anyTimes();
        EasyMock.replay((Object[])new Object[]{conn});
        return conn;
    }

    @Test
    public void escapeTableName_noSchema() {
        AbstractDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"tableName", (Object)database.escapeTableName(null, "tableName"));
    }

    @Test
    public void escapeTableName_withSchema() {
        AbstractDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"schemaName.tableName", (Object)database.escapeTableName("schemaName", "tableName"));
    }
}

